/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml;

import com.google.common.collect.Iterables;
import jakarta.xml.bind.Binder;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.JAXBSerializer;
import org.jpmml.model.JAXBUtil;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.visitors.AbstractVisitor;
import org.jpmml.sklearn.SkLearnException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.Locator;
import sklearn2pmml.Customization;

public class CustomizationUtil {
    private CustomizationUtil() {
    }

    public static void customize(Model model, List<? extends Customization> customizations) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        DocumentNamespaceContext namespaceContext = new DocumentNamespaceContext(document);
        JAXBContext context = JAXBUtil.getContext();
        Binder binder = context.createBinder(Node.class);
        binder.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        binder.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        binder.marshal((Object)model, (Object)document);
        for (Customization customization : customizations) {
            Node node;
            PMMLObject object;
            PMMLObject pmmlElementObject;
            Model xPathExprObject;
            String command;
            switch (command = customization.getCommand()) {
                case "insert": 
                case "update": {
                    String xPathExpr = customization.getOptionalXPathExpr();
                    if (xPathExpr == null) {
                        xPathExprObject = model;
                        break;
                    }
                }
                case "delete": {
                    String xPathExpr = customization.getXPathExpr();
                    XPath xPath = xPathFactory.newXPath();
                    xPath.setNamespaceContext(namespaceContext);
                    XPathExpression xPathExpression = xPath.compile(xPathExpr);
                    Node node2 = (Node)xPathExpression.evaluate(document.getDocumentElement(), XPathConstants.NODE);
                    xPathExprObject = (PMMLObject)binder.getJAXBNode((Object)node2);
                    if (xPathExprObject != null) break;
                    throw new SkLearnException("XPath expression '" + xPathExpr + "' is not associated with a PMML object");
                }
                default: {
                    throw new IllegalArgumentException(command);
                }
            }
            switch (command) {
                case "insert": 
                case "update": {
                    String pmmlElement = customization.getPMMLElement();
                    pmmlElementObject = (PMMLObject)CustomizationUtil.parsePMML(pmmlElement);
                    break;
                }
                case "delete": {
                    pmmlElementObject = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(command);
                }
            }
            switch (command) {
                case "insert": {
                    object = CustomizationUtil.insert((PMMLObject)xPathExprObject, pmmlElementObject);
                    break;
                }
                case "update": {
                    object = CustomizationUtil.update((PMMLObject)xPathExprObject, pmmlElementObject);
                    break;
                }
                case "delete": {
                    HashSet parents = new HashSet();
                    AbstractVisitor parentFinder = new AbstractVisitor((PMMLObject)xPathExprObject, parents){
                        final /* synthetic */ PMMLObject val$xPathExprObject;
                        final /* synthetic */ Set val$parents;
                        {
                            this.val$xPathExprObject = pMMLObject;
                            this.val$parents = set;
                        }

                        public VisitorAction visit(PMMLObject object) {
                            if (Objects.equals(this.val$xPathExprObject, object)) {
                                PMMLObject parent = this.getParent();
                                this.val$parents.add(parent);
                                return VisitorAction.TERMINATE;
                            }
                            return super.visit(object);
                        }
                    };
                    parentFinder.applyTo((Visitable)model);
                    if (parents.size() != 1) {
                        throw new IllegalArgumentException();
                    }
                    object = CustomizationUtil.delete((PMMLObject)Iterables.getOnlyElement(parents), (PMMLObject)xPathExprObject);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(command);
                }
            }
            if (object == null || (node = (Node)binder.getXMLNode((Object)object)) == null) continue;
            binder.updateXML((Object)object, (Object)node);
        }
    }

    private static PMMLObject insert(PMMLObject parent, PMMLObject child) throws ReflectiveOperationException {
        Field field = CustomizationUtil.findField(parent, child);
        Class<?> fieldType = field.getType();
        if (Objects.equals(List.class, fieldType)) {
            CustomizationUtil.addListElement(field, parent, child);
        } else {
            PMMLObject fieldValue = (PMMLObject)ReflectionUtil.getFieldValue((Field)field, (Object)parent);
            if (fieldValue != null) {
                throw new IllegalArgumentException();
            }
            ReflectionUtil.setFieldValue((Field)field, (Object)parent, (Object)child);
        }
        return parent;
    }

    private static PMMLObject update(PMMLObject target, PMMLObject source) {
        Class<?> sourceClazz;
        Class<?> targetClazz = target.getClass();
        if (!Objects.equals(targetClazz, sourceClazz = source.getClass())) {
            throw new IllegalArgumentException();
        }
        List fields = ReflectionUtil.getFields(targetClazz);
        for (Field field : fields) {
            Object sourceValue;
            Class<?> fieldType = field.getType();
            if (Objects.equals(Locator.class, fieldType) || (sourceValue = ReflectionUtil.getFieldValue((Field)field, (Object)source)) == null) continue;
            ReflectionUtil.setFieldValue((Field)field, (Object)target, (Object)sourceValue);
        }
        return target;
    }

    private static PMMLObject delete(PMMLObject parent, PMMLObject child) {
        Field field = CustomizationUtil.findField(parent, child);
        Class<?> fieldType = field.getType();
        if (Objects.equals(List.class, fieldType)) {
            CustomizationUtil.removeListElement(field, parent, child);
        } else {
            ReflectionUtil.setFieldValue((Field)field, (Object)parent, null);
        }
        return parent;
    }

    private static Field findField(PMMLObject parent, PMMLObject child) {
        Class<?> parentClazz = parent.getClass();
        Class<?> childClazz = child.getClass();
        List fields = ReflectionUtil.getFields(parentClazz);
        for (Field field : fields) {
            ParameterizedType listType;
            Class listElementType;
            Class<?> fieldType = field.getType();
            if (!(Objects.equals(List.class, fieldType) ? PMMLObject.class.isAssignableFrom(listElementType = (Class)(listType = (ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) && listElementType.isAssignableFrom(childClazz) : PMMLObject.class.isAssignableFrom(fieldType) && fieldType.isAssignableFrom(childClazz))) continue;
            return field;
        }
        throw new IllegalArgumentException();
    }

    private static void addListElement(Field field, PMMLObject parent, PMMLObject child) throws ReflectiveOperationException {
        List fieldValue = (List)ReflectionUtil.getFieldValue((Field)field, (Object)parent);
        ParameterizedType listType = (ParameterizedType)field.getGenericType();
        Class listElementType = (Class)listType.getActualTypeArguments()[0];
        Method appenderMethod = ReflectionUtil.getAppenderMethod((Field)field);
        Object[] valueArray = (Object[])Array.newInstance(listElementType, 1);
        valueArray[0] = child;
        appenderMethod.invoke((Object)parent, new Object[]{valueArray});
    }

    private static void removeListElement(Field field, PMMLObject parent, PMMLObject child) {
        List fieldValue = (List)ReflectionUtil.getFieldValue((Field)field, (Object)parent);
        boolean success = fieldValue.remove(child);
        if (!success) {
            throw new IllegalArgumentException();
        }
    }

    private static <E extends PMMLObject> JAXBElement<E> createElement(E object) {
        Class<?> objectClazz = object.getClass();
        XmlRootElement xmlRootElement = objectClazz.getAnnotation(XmlRootElement.class);
        if (xmlRootElement == null) {
            throw new IllegalArgumentException();
        }
        return new JAXBElement(new QName(xmlRootElement.namespace(), xmlRootElement.name()), objectClazz, object);
    }

    public static Object parsePMML(String string) {
        PMMLObject pMMLObject;
        StringReader reader = new StringReader(string);
        try {
            JAXBSerializer jaxbSerializer = new JAXBSerializer();
            pMMLObject = jaxbSerializer.unmarshal((Source)new StreamSource(reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new SkLearnException("Failed to parse PMML string", e);
            }
        }
        ((Reader)reader).close();
        return pMMLObject;
    }

    public static String formatPMML(PMMLObject object) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            JAXBSerializer jaxbSerializer = new JAXBSerializer();
            jaxbSerializer.marshal(object, (Result)new StreamResult(writer));
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new SkLearnException("Failed to format PMML object", e);
            }
        }
        writer.close();
        return string;
    }

    private static class DocumentNamespaceContext
    implements NamespaceContext {
        private Document document = null;

        private DocumentNamespaceContext(Document document) {
            this.setDocument(document);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            Document document = this.getDocument();
            if (Objects.equals("", prefix)) {
                return document.lookupNamespaceURI(null);
            }
            return document.lookupNamespaceURI(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            Document document = this.getDocument();
            return document.lookupPrefix(namespaceURI);
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        public Document getDocument() {
            return this.document;
        }

        private void setDocument(Document document) {
            this.document = document;
        }
    }
}

