/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.ensemble;

import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.python.DataFrameScope;
import org.jpmml.python.Scope;
import org.jpmml.python.TupleUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Estimator;
import sklearn.Transformer;
import sklearn2pmml.ensemble.HasEstimatorSteps;
import sklearn2pmml.util.EvaluatableUtil;

public class SelectFirstUtil {
    private SelectFirstUtil() {
    }

    public static <E extends Estimator> MiningModel encodeSelectFirstEstimator(E ensembleEstimator, Schema schema) {
        Transformer controller = ((HasEstimatorSteps)((Object)ensembleEstimator)).getController();
        List<Object[]> steps = ((HasEstimatorSteps)((Object)ensembleEstimator)).getSteps();
        if (steps.isEmpty()) {
            throw new IllegalArgumentException();
        }
        SkLearnEncoder encoder = (SkLearnEncoder)schema.getEncoder();
        Label label = schema.getLabel();
        List<Feature> features = schema.getFeatures();
        MiningFunction miningFunction = ensembleEstimator.getMiningFunction();
        Segmentation segmentation = new Segmentation(Segmentation.MultipleModelMethod.SELECT_FIRST, null);
        List<Feature> controlFeatures = features;
        if (controller != null) {
            controlFeatures = controller.encode(controlFeatures, encoder);
        }
        DataFrameScope scope = new DataFrameScope("X", controlFeatures);
        for (int i = 0; i < steps.size(); ++i) {
            Object[] step = steps.get(i);
            String name = (String)TupleUtil.extractElement((Object[])step, (int)0, String.class);
            Estimator estimator = (Estimator)TupleUtil.extractElement((Object[])step, (int)1, Estimator.class);
            Object expr = TupleUtil.extractElement((Object[])step, (int)2, Object.class);
            if (estimator.getMiningFunction() != miningFunction) {
                throw new IllegalArgumentException();
            }
            Predicate predicate = EvaluatableUtil.translatePredicate(expr, (Scope)scope);
            Model model = estimator.encode(schema);
            Segment segment = new Segment(predicate, model).setId(name);
            segmentation.addSegments(new Segment[]{segment});
        }
        MiningModel miningModel = new MiningModel(miningFunction, ModelUtil.createMiningSchema((Label)label)).setSegmentation(segmentation);
        MiningModelUtil.optimizeOutputFields((MiningModel)miningModel);
        return miningModel;
    }
}

