/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.dmg.pmml.BlockIndicator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.PythonException;
import org.jpmml.sklearn.SkLearnException;

public class BlockIndicatorUtil {
    private BlockIndicatorUtil() {
    }

    public static List<Feature> selectFeatures(List<?> blockIndiators, final List<Feature> features) {
        Function<Object, Feature> castFunction = new Function<Object, Feature>(){

            public Feature apply(Object object) {
                if (object instanceof String) {
                    String column = (String)object;
                    Feature feature = FeatureUtil.findFeature((List)features, (String)column);
                    if (feature != null) {
                        return feature;
                    }
                    throw new SkLearnException("Column '" + column + "' not found in " + FeatureUtil.formatNames((List)features, (char)'\''));
                }
                if (object instanceof Integer) {
                    Integer index = (Integer)object;
                    return (Feature)features.get(index);
                }
                throw new PythonException("The block indicator object (" + ClassDictUtil.formatClass((Object)object) + ") is not a string nor integer");
            }
        };
        return Lists.transform(blockIndiators, (Function)castFunction);
    }

    public static BlockIndicator[] toBlockIndicators(List<Feature> features) {
        return (BlockIndicator[])features.stream().map(feature -> new BlockIndicator(feature.getName())).toArray(BlockIndicator[]::new);
    }
}

