/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.List;
import java.util.Map;
import org.jpmml.python.PythonObject;
import org.jpmml.sklearn.SkLearnException;
import sklearn.HasNumberOfFeatures;
import sklearn.HasType;
import sklearn.StepUtil;
import sklearn.VersionUtil;

public abstract class Step
extends PythonObject
implements HasNumberOfFeatures,
HasType {
    public Step(String module, String name) {
        super(module, name);
    }

    public void checkVersion() {
        this.checkSkLearnVersion();
    }

    public void checkSkLearnVersion() {
        String sklearnVersion = this.getSkLearnVersion();
        if (sklearnVersion != null && VersionUtil.compareVersion(sklearnVersion, "1.7.1") > 0) {
            String message = "This converter version does not know about Scikit-Learn version " + sklearnVersion + " artifacts. Please upgrade the converter to the latest version, or downgrade Scikit-Learn to version 1.7.1";
            throw new SkLearnException(message);
        }
    }

    public List<String> getFeatureNamesIn() {
        if (this.hasattr("feature_names_in_")) {
            return this.getListLike("feature_names_in_", String.class);
        }
        return null;
    }

    public Map<String, ?> getInputTags() {
        return (Map)StepUtil.getTag(this.getSkLearnTags(), "input_tags");
    }

    public String getPMMLName() {
        return this.getOptionalString("pmml_name_");
    }

    public Step setPMMLName(String pmmlName) {
        this.setattr("pmml_name_", pmmlName);
        return this;
    }

    public Map<String, ?> getSkLearnTags() {
        return this.getOptionalDict("_sklearn_tags");
    }

    public String getSkLearnVersion() {
        return this.getOptionalString("_sklearn_version");
    }
}

