/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.razorvine.pickle.objects.ClassDictConstructor;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.python.AttributeException;
import org.jpmml.python.ClassDictConstructorUtil;
import org.jpmml.python.FunctionUtil;
import org.jpmml.python.Identifiable;
import org.jpmml.sklearn.SkLearnEncoder;
import org.jpmml.sklearn.SkLearnException;
import sklearn.IdentifiableUtil;
import sklearn.SkLearnTransformer;
import sklearn2pmml.preprocessing.ExpressionTransformer;

public class FunctionTransformer
extends SkLearnTransformer {
    public FunctionTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Identifiable func = this.getFunc();
        if (func == null) {
            return features;
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            Apply expression = FunctionUtil.encodeFunction((Identifiable)func, Collections.singletonList(continuousFeature.ref()));
            DerivedField derivedField = encoder.createDerivedField(this.createFieldName(func.getName(), continuousFeature), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)expression);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }

    public Identifiable getFunc() {
        Identifiable func;
        try {
            func = this.getOptionalIdentifiable("func");
        }
        catch (AttributeException ae) {
            String name = this.getFunctionName("func");
            if (name != null && name.startsWith("__main__.")) {
                name = name.substring("__main__.".length());
                String message = "The function '" + name + " ' does not have a persistent state. Please use the " + ExpressionTransformer.class.getName() + " transformer class to give the function a persistent state (eg. " + ExpressionTransformer.formatExpressionExample(name) + ")";
                throw new SkLearnException(message, ae);
            }
            throw ae;
        }
        return IdentifiableUtil.filter(func);
    }

    public Identifiable getInverseFunc() {
        Identifiable inverseFunc = this.getOptionalIdentifiable("inverse_func");
        return IdentifiableUtil.filter(inverseFunc);
    }

    private String getFunctionName(String name) {
        Object object = this.getOptionalObject(name);
        if (object instanceof ClassDictConstructor) {
            ClassDictConstructor dictConstructor = (ClassDictConstructor)object;
            return ClassDictConstructorUtil.getClassName((ClassDictConstructor)dictConstructor);
        }
        return null;
    }
}

