/*
 * Decompiled with CFR 0.152.
 */
package sklearn.decomposition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.decomposition.BasePCA;

public class TruncatedSVD
extends BasePCA {
    public TruncatedSVD(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        int[] shape = this.getComponentsShape();
        int numberOfComponents = shape[0];
        int numberOfFeatures = shape[1];
        List<Number> components = this.getComponents();
        ClassDictUtil.checkSize((int)numberOfFeatures, (Collection[])new Collection[]{features});
        String name = this.createFieldName("svd", features);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < numberOfComponents; ++i) {
            List component = CMatrixUtil.getRow(components, (int)numberOfComponents, (int)numberOfFeatures, (int)i);
            Apply apply = ExpressionUtil.createApply((String)"sum", (Expression[])new Expression[0]);
            for (int j = 0; j < numberOfFeatures; ++j) {
                Feature feature = features.get(j);
                Number componentValue = (Number)component.get(j);
                if (ValueUtil.isOne((Number)componentValue)) {
                    apply.addExpressions(new Expression[]{feature.ref()});
                    continue;
                }
                ContinuousFeature continuousFeature = feature.toContinuousFeature();
                Apply expression = ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{continuousFeature.ref(), ExpressionUtil.createConstant((Number)componentValue)});
                apply.addExpressions(new Expression[]{expression});
            }
            DerivedField derivedField = encoder.createDerivedField(FieldNameUtil.select((String)name, (int)i), (Expression)apply);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }
}

