/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.razorvine.pickle.objects.ClassDict;
import org.dmg.pmml.PMML;
import org.jpmml.python.AttributeException;
import org.jpmml.python.CastFunction;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.Encodable;
import sklearn.Estimator;
import sklearn.Step;
import sklearn.pipeline.SkLearnPipeline;

public class EncodableUtil {
    private EncodableUtil() {
    }

    public static Encodable toEncodable(Object object) {
        if (object instanceof Encodable) {
            Encodable encodable = (Encodable)object;
            return encodable;
        }
        CastFunction<Step> castFunction = new CastFunction<Step>(Step.class){

            protected String formatMessage(Object object) {
                return "The object (" + ClassDictUtil.formatClass((Object)object) + ") is not a supported Transformer or Estimator";
            }
        };
        final Step step = (Step)castFunction.apply(object);
        if (step instanceof Encodable) {
            Encodable encodable = (Encodable)((Object)step);
            return encodable;
        }
        SkLearnPipeline pipeline = new SkLearnPipeline(){
            {
                List<Object[]> steps = Collections.singletonList(new Object[]{"estimator", step});
                this.setSteps(steps);
            }

            @Override
            public PMML encodePMML() {
                return super.encodePMML();
            }
        };
        return pipeline;
    }

    public static List<String> getOrGenerateFeatureNames(Step step) {
        List<String> names = step.getFeatureNamesIn();
        if (names == null) {
            return EncodableUtil.generateFeatureNames(step);
        }
        return names;
    }

    public static List<String> generateFeatureNames(Step step) {
        int numberOfFeatures = step.getNumberOfFeatures();
        if (numberOfFeatures == -1) {
            throw new AttributeException("Attribute '" + ClassDictUtil.formatMember((ClassDict)step, (String)"n_features_in_") + "' is not set");
        }
        return EncodableUtil.generateNames("x", numberOfFeatures, true);
    }

    public static List<String> generateOutputNames(Estimator estimator) {
        int numberOfOutputs = estimator.getNumberOfOutputs();
        if (numberOfOutputs == -1) {
            throw new AttributeException("Attribute '" + ClassDictUtil.formatMember((ClassDict)estimator, (String)"n_outputs_") + "' is not set");
        }
        return EncodableUtil.generateNames("y", numberOfOutputs, false);
    }

    private static List<String> generateNames(String name, int count, boolean indexed) {
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        if (count == 1) {
            return Collections.singletonList(name + (indexed ? "1" : ""));
        }
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            result.add(name + String.valueOf(i + 1));
        }
        return result;
    }
}

