/*
 * Decompiled with CFR 0.152.
 */
package sklearn.loss;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import sklearn.HasPriorProbability;
import sklearn.loss.Link;

public class MultinomialLogit
extends Link {
    public MultinomialLogit(String module, String name) {
        super(module, name);
    }

    public List<Double> computeInitialPredictions(final int numClasses, HasPriorProbability hasPriorProbability) {
        final ArrayList<Number> priorProbabilities = new ArrayList<Number>();
        for (int i = 0; i < numClasses; ++i) {
            priorProbabilities.add(hasPriorProbability.getPriorProbability(i));
        }
        final double gmean = MultinomialLogit.gmean(priorProbabilities);
        AbstractList<Double> result = new AbstractList<Double>(){

            @Override
            public int size() {
                return numClasses;
            }

            @Override
            public Double get(int index) {
                Number priorProbability = (Number)priorProbabilities.get(index);
                return Math.log(priorProbability.doubleValue() / gmean);
            }
        };
        return result;
    }

    public static double gmean(List<? extends Number> values) {
        double logSum = 0.0;
        for (Number number : values) {
            double doubleValue = number.doubleValue();
            if (doubleValue == 0.0) {
                return Double.NaN;
            }
            logSum += Math.log(doubleValue);
        }
        return Math.exp(logSum / (double)values.size());
    }
}

