/*
 * Decompiled with CFR 0.152.
 */
package sklearn.multioutput;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.ScalarLabelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Estimator;

public class ChainUtil {
    private ChainUtil() {
    }

    public static <E extends Estimator> MiningModel encodeChain(List<E> estimators, List<Integer> order, Schema schema) {
        SkLearnEncoder encoder = (SkLearnEncoder)schema.getEncoder();
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        List scalarLabels = ScalarLabelUtil.toScalarLabels((Label)label);
        ClassDictUtil.checkSize((Collection[])new Collection[]{estimators, order, scalarLabels});
        ArrayList<Model> models = new ArrayList<Model>();
        ArrayList<Feature> augmentedFeatures = new ArrayList<Feature>(features);
        for (int i = 0; i < estimators.size(); ++i) {
            Estimator estimator = (Estimator)estimators.get(i);
            ScalarLabel scalarLabel = (ScalarLabel)scalarLabels.get(i);
            if (order.get(i) != i) {
                throw new IllegalArgumentException();
            }
            Schema segmentSchema = new Schema((ModelEncoder)encoder, (Label)scalarLabel, augmentedFeatures);
            Model model = estimator.encode(scalarLabel.getName(), segmentSchema);
            models.add(model);
            Feature feature = encoder.exportPrediction(model, scalarLabel);
            augmentedFeatures.add(feature);
        }
        return MiningModelUtil.createMultiModelChain(models, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.CONTINUE);
    }
}

