/*
 * Decompiled with CFR 0.152.
 */
package sklearn.naive_bayes;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.naive_bayes.BayesInputs;
import org.dmg.pmml.naive_bayes.BayesOutput;
import org.dmg.pmml.naive_bayes.NaiveBayesModel;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.DiscreteLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import sklearn.SkLearnClassifier;
import sklearn.naive_bayes.DiscreteNBUtil;

public abstract class DiscreteNB
extends SkLearnClassifier {
    public DiscreteNB(String module, String name) {
        super(module, name);
    }

    public abstract BayesInputs encodeBayesInputs(List<?> var1, List<? extends Feature> var2);

    public NaiveBayesModel encodeModel(Schema schema) {
        List<Integer> classCount = this.getClassCount();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        List features = schema.getFeatures();
        List values = categoricalLabel.getValues();
        BayesInputs bayesInputs = this.encodeBayesInputs(values, features);
        BayesOutput bayesOutput = new BayesOutput().setTargetField(categoricalLabel.getName()).setTargetValueCounts(DiscreteNBUtil.encodeTargetValueCounts(values, classCount));
        NaiveBayesModel naiveBayesModel = new NaiveBayesModel((Number)0.0, MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)categoricalLabel), bayesInputs, bayesOutput);
        this.encodePredictProbaOutput((Model)naiveBayesModel, DataType.DOUBLE, (DiscreteLabel)categoricalLabel);
        return naiveBayesModel;
    }

    public Number getAlpha() {
        return this.getNumber("alpha");
    }

    public List<Integer> getClassCount() {
        return this.getIntegerArray("class_count_");
    }
}

