/*
 * Decompiled with CFR 0.152.
 */
package sklearn.naive_bayes;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.dmg.pmml.naive_bayes.PairCounts;
import org.dmg.pmml.naive_bayes.TargetValueCount;
import org.dmg.pmml.naive_bayes.TargetValueCounts;

public class DiscreteNBUtil {
    private DiscreteNBUtil() {
    }

    public static PairCounts encodePairCounts(Object value, List<?> values, final Number alpha, List<? extends Number> counts) {
        if (alpha.doubleValue() != 0.0) {
            Function<Number, Number> function = new Function<Number, Number>(){

                public Number apply(Number count) {
                    return count.doubleValue() + alpha.doubleValue();
                }
            };
            counts = Lists.transform(counts, (Function)function);
        }
        PairCounts pairCounts = new PairCounts().setValue(value).setTargetValueCounts(DiscreteNBUtil.encodeTargetValueCounts(values, counts));
        return pairCounts;
    }

    public static TargetValueCounts encodeTargetValueCounts(List<?> values, List<? extends Number> counts) {
        TargetValueCounts targetValueCounts = new TargetValueCounts();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            Number count = counts.get(i);
            TargetValueCount targetValueCount = new TargetValueCount(value, count);
            targetValueCounts.addTargetValueCounts(new TargetValueCount[]{targetValueCount});
        }
        return targetValueCounts;
    }
}

