/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.python.Castable;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.EncodableUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import org.jpmml.sklearn.SkLearnException;
import sklearn.Classifier;
import sklearn.Clusterer;
import sklearn.CompositeClassifier;
import sklearn.CompositeClusterer;
import sklearn.CompositeRegressor;
import sklearn.CompositeTransformer;
import sklearn.Estimator;
import sklearn.HasFeatureNamesIn;
import sklearn.HasHead;
import sklearn.Initializer;
import sklearn.Regressor;
import sklearn.Step;
import sklearn.Transformer;

public abstract class Composite
extends Step
implements Castable,
HasFeatureNamesIn,
HasHead {
    public Composite(String module, String name) {
        super(module, name);
    }

    public abstract boolean hasTransformers();

    public abstract List<? extends Transformer> getTransformers();

    public abstract boolean hasFinalEstimator();

    public abstract Estimator getFinalEstimator();

    public abstract <E extends Estimator> E getFinalEstimator(Class<? extends E> var1);

    @Override
    public List<String> getFeatureNamesIn() {
        Step head = this.getHead();
        if (head != null) {
            return head.getFeatureNamesIn();
        }
        return null;
    }

    @Override
    public int getNumberOfFeatures() {
        Step head = this.getHead();
        if (head != null) {
            return head.getNumberOfFeatures();
        }
        return -1;
    }

    @Override
    public OpType getOpType() {
        Step head = this.getHead();
        if (head != null) {
            return head.getOpType();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType getDataType() {
        Step head = this.getHead();
        if (head != null) {
            return head.getDataType();
        }
        throw new UnsupportedOperationException();
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        if (this.hasTransformers()) {
            List<? extends Transformer> transformers = this.getTransformers();
            for (Transformer transformer : transformers) {
                features = transformer.encode(features, encoder);
            }
        }
        return features;
    }

    public Model encodeModel(Schema schema) {
        SkLearnEncoder encoder = (SkLearnEncoder)schema.getEncoder();
        Label label = schema.getLabel();
        List<Feature> features = schema.getFeatures();
        if (this.hasTransformers()) {
            features = this.encodeFeatures(features, encoder);
            label = this.refreshLabel(label, encoder);
            schema = new Schema((ModelEncoder)encoder, label, features);
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.encode(schema);
        }
        throw new UnsupportedOperationException();
    }

    protected Label refreshLabel(Label label, SkLearnEncoder encoder) {
        return label;
    }

    public Object castTo(Class<?> clazz) {
        if (Transformer.class.equals(clazz)) {
            return this.toTransformer();
        }
        if (Estimator.class.equals(clazz)) {
            return this.toEstimator();
        }
        if (Classifier.class.equals(clazz)) {
            return this.toClassifier();
        }
        if (Regressor.class.equals(clazz)) {
            return this.toRegressor();
        }
        if (Clusterer.class.equals(clazz)) {
            return this.toClusterer();
        }
        return this;
    }

    public Transformer toTransformer() {
        Estimator estimator;
        if (this.hasFinalEstimator() && (estimator = this.getFinalEstimator()) != null) {
            throw new SkLearnException("The pipeline ends with an estimator object");
        }
        return new CompositeTransformer(this);
    }

    public Estimator toEstimator() {
        Estimator estimator = this.getFinalEstimator();
        MiningFunction miningFunction = estimator.getMiningFunction();
        switch (miningFunction) {
            case CLASSIFICATION: {
                return this.toClassifier();
            }
            case REGRESSION: {
                return this.toRegressor();
            }
            case CLUSTERING: {
                return this.toClusterer();
            }
        }
        throw new IllegalArgumentException();
    }

    public Classifier toClassifier() {
        return new CompositeClassifier(this);
    }

    public Regressor toRegressor() {
        return new CompositeRegressor(this);
    }

    public Clusterer toClusterer() {
        return new CompositeClusterer(this);
    }

    protected List<String> initLabel(List<String> targetFields, SkLearnEncoder encoder) {
        Estimator estimator = this.getFinalEstimator();
        if (estimator != null && estimator.isSupervised()) {
            if (targetFields == null) {
                targetFields = this.initTargetFields(estimator);
            }
            encoder.initLabel(estimator, targetFields);
        }
        return targetFields;
    }

    protected List<String> initTargetFields(Estimator estimator) {
        return EncodableUtil.generateOutputNames(estimator);
    }

    protected List<String> initFeatures(List<String> activeFields, SkLearnEncoder encoder) {
        block7: {
            Step head = this.getHead();
            try {
                if (head instanceof Transformer) {
                    if (!(head instanceof Initializer)) {
                        if (activeFields == null) {
                            activeFields = this.initActiveFields(head);
                        }
                        encoder.initFeatures(head, activeFields);
                    }
                    List<Feature> features = new ArrayList<Feature>();
                    features.addAll(encoder.getFeatures());
                    features = this.encodeFeatures(features, encoder);
                    encoder.setFeatures(features);
                    break block7;
                }
                if (head instanceof Estimator) {
                    if (activeFields == null) {
                        activeFields = this.initActiveFields(head);
                    }
                    encoder.initFeatures(head, activeFields);
                    break block7;
                }
                throw new SkLearnException("The head object (" + ClassDictUtil.formatClass((Object)head) + ") is not a supported Transformer or Estimator");
            }
            catch (UnsupportedOperationException uoe) {
                throw new SkLearnException("The feature initializer object (" + ClassDictUtil.formatClass((Object)head) + ") does not specify feature type information");
            }
        }
        return activeFields;
    }

    protected List<String> initActiveFields(Step step) {
        return EncodableUtil.getOrGenerateFeatureNames(step);
    }
}

