/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnException;
import sklearn.HasHead;
import sklearn.HasMultiType;
import sklearn.Step;

public class StepUtil {
    private StepUtil() {
    }

    public static Step getHead(Step step) {
        if (step instanceof HasHead) {
            HasHead hasHead = (HasHead)((Object)step);
            return hasHead.getHead();
        }
        return step;
    }

    public static int getNumberOfFeatures(List<? extends Step> steps) {
        Iterator<? extends Step> iterator = steps.iterator();
        if (iterator.hasNext()) {
            Step step = iterator.next();
            return step.getNumberOfFeatures();
        }
        return -1;
    }

    public static void checkNumberOfFeatures(Step step, List<? extends Feature> features) {
        int numberOfFeatures = step.getNumberOfFeatures();
        if (numberOfFeatures != -1 && numberOfFeatures != features.size()) {
            throw new SkLearnException("Expected " + numberOfFeatures + " feature(s) (" + ClassDictUtil.formatClass((Object)step) + "), got " + features.size() + " feature(s)");
        }
    }

    public static Object getTag(Map<String, ?> tags, String name) {
        return StepUtil.getTag(tags, name, null);
    }

    public static Object getTag(Map<String, ?> tags, String name, Object defaultValue) {
        if (tags != null) {
            return tags.getOrDefault(name, defaultValue);
        }
        return defaultValue;
    }

    public static HasMultiType getType(final Step step) {
        if (step instanceof HasMultiType) {
            HasMultiType hasMultiType = (HasMultiType)((Object)step);
            return hasMultiType;
        }
        HasMultiType hasMultiType = new HasMultiType(){
            private OpType opType = null;
            private DataType dataType = null;

            @Override
            public OpType getOpType() {
                if (this.opType == null) {
                    this.opType = step.getOpType();
                }
                return this.opType;
            }

            @Override
            public DataType getDataType() {
                if (this.dataType == null) {
                    this.dataType = step.getDataType();
                }
                return this.dataType;
            }
        };
        return hasMultiType;
    }
}

