/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.iforest;

import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.transformations.AbstractTransformation;
import org.jpmml.model.visitors.AbstractVisitor;
import sklearn.Estimator;
import sklearn.HasDecisionFunctionField;
import sklearn.OutlierDetector;
import sklearn.OutlierDetectorUtil;
import sklearn.ensemble.iforest.HasIsolationForest;
import sklearn.tree.Tree;

public class IsolationForestUtil {
    private IsolationForestUtil() {
    }

    public static <E extends Estimator & OutlierDetector> MiningModel encodeMiningModel(final E estimator, List<TreeModel> treeModels, final boolean corrected, final boolean nodeSampleCorrected, Schema schema) {
        AbstractTransformation normalizedAnomalyScore = new AbstractTransformation(){

            public String getName(String name) {
                return "normalizedAnomalyScore";
            }

            public Expression createExpression(FieldRef fieldRef) {
                double maxSamples = ((HasIsolationForest)((Object)estimator)).getMaxSamples().intValue();
                double averagePathLength = corrected ? IsolationForestUtil.correctedAveragePathLength(maxSamples, nodeSampleCorrected) : IsolationForestUtil.averagePathLength(maxSamples);
                return ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{fieldRef, ExpressionUtil.createConstant((Number)averagePathLength)});
            }
        };
        AbstractTransformation decisionFunction = new AbstractTransformation(){

            public String getName(String name) {
                return ((HasDecisionFunctionField)((Object)estimator)).getDecisionFunctionField();
            }

            public boolean isFinalResult() {
                return true;
            }

            public Expression createExpression(FieldRef fieldRef) {
                Number offset = ((HasIsolationForest)((Object)estimator)).getOffset();
                return ExpressionUtil.createApply((String)"-", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)(-offset.doubleValue())), ExpressionUtil.createApply((String)"pow", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)2.0), ExpressionUtil.toNegative((Expression)fieldRef)})});
            }
        };
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)schema.getLabel())).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)Segmentation.MultipleModelMethod.AVERAGE, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING, treeModels)).setOutput(OutlierDetectorUtil.createPredictedOutput(estimator, "rawAnomalyScore", new Transformation[]{normalizedAnomalyScore, decisionFunction}));
        return miningModel;
    }

    public static void transformTreeModel(TreeModel treeModel, final Tree tree, final boolean corrected, final boolean nodeSampleCorrected) {
        AbstractVisitor visitor = new AbstractVisitor(){
            private int[] nodeSamples;
            {
                this.nodeSamples = tree.getNodeSamples();
            }

            public VisitorAction visit(Node node) {
                if (node.hasScore()) {
                    PMMLObject parent;
                    double nodeDepth = 0.0;
                    Deque parents = this.getParents();
                    Iterator iterator = parents.iterator();
                    while (iterator.hasNext() && (parent = (PMMLObject)iterator.next()) instanceof Node) {
                        nodeDepth += 1.0;
                    }
                    double nodeSample = this.nodeSamples[ValueUtil.asInt((Number)((Number)node.getId()))];
                    double averagePathLength = corrected ? IsolationForestUtil.correctedAveragePathLength(nodeSample, nodeSampleCorrected) : IsolationForestUtil.averagePathLength(nodeSample);
                    node.setScore((Object)(nodeDepth + averagePathLength));
                }
                return super.visit(node);
            }
        };
        visitor.applyTo((Visitable)treeModel);
    }

    private static double averagePathLength(double n) {
        if (n <= 1.0) {
            return 1.0;
        }
        return 2.0 * (Math.log(n) + 0.5772156649) - 2.0 * ((n - 1.0) / n);
    }

    private static double correctedAveragePathLength(double n, boolean nodeSampleCorrected) {
        if (nodeSampleCorrected) {
            if (n <= 1.0) {
                return 0.0;
            }
            if (n <= 2.0) {
                return 1.0;
            }
        } else if (n <= 1.0) {
            return 1.0;
        }
        return 2.0 * (Math.log(n - 1.0) + 0.5772156649015329) - 2.0 * ((n - 1.0) / n);
    }
}

