/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasSparseOutput;
import sklearn.SkLearnTransformer;

public class LabelBinarizer
extends SkLearnTransformer
implements HasSparseOutput {
    public LabelBinarizer(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<Object> classes = this.getClasses();
        return TypeUtil.getDataType(classes, (DataType)DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<Object> classes = this.getClasses();
        Number negLabel = this.getNegLabel();
        Number posLabel = this.getPosLabel();
        ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{features});
        Feature feature = features.get(0);
        ArrayList<Object> categories = new ArrayList<Object>();
        categories.addAll(classes);
        ArrayList<Number> labelCategories = new ArrayList<Number>();
        labelCategories.add(negLabel);
        labelCategories.add(posLabel);
        ArrayList<Feature> result = new ArrayList<Feature>();
        classes = this.prepareClasses(classes);
        for (int i = 0; i < classes.size(); ++i) {
            Object value = classes.get(i);
            if (ValueUtil.isZero((Number)negLabel) && ValueUtil.isOne((Number)posLabel)) {
                result.add((Feature)new BinaryFeature((PMMLEncoder)encoder, feature, value));
                continue;
            }
            Apply apply = ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"equal", (Expression[])new Expression[]{feature.ref(), ExpressionUtil.createConstant((DataType)feature.getDataType(), (Object)value)}), ExpressionUtil.createConstant((Number)posLabel), ExpressionUtil.createConstant((Number)negLabel)});
            String name = classes.size() > 1 ? this.createFieldName("labelBinarizer", feature, value) : this.createFieldName("labelBinarizer", feature);
            DerivedField derivedField = encoder.createDerivedField(name, (Expression)apply);
            result.add((Feature)new CategoricalFeature((PMMLEncoder)encoder, (Field)derivedField, labelCategories));
        }
        encoder.toCategorical(feature.getName(), categories);
        return result;
    }

    protected List<?> prepareClasses(List<?> classes) {
        if (classes.size() == 2) {
            return classes.subList(1, 2);
        }
        if (classes.size() >= 3) {
            return classes;
        }
        throw new IllegalArgumentException();
    }

    public List<Object> getClasses() {
        return this.getObjectArray("classes_");
    }

    public Number getNegLabel() {
        return this.getNumber("neg_label");
    }

    public Number getPosLabel() {
        return this.getNumber("pos_label");
    }

    @Override
    public Boolean getSparseOutput() {
        return this.getBoolean("sparse_output");
    }
}

