/*
 * Decompiled with CFR 0.152.
 */
package sklearn.svm;

import com.google.common.collect.Iterables;
import java.util.List;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.jpmml.converter.CMatrix;
import org.jpmml.converter.Matrix;
import org.jpmml.converter.Schema;
import org.jpmml.converter.support_vector_machine.LibSVMUtil;
import sklearn.SkLearnRegressor;
import sklearn.svm.HasLibSVMKernel;
import sklearn.svm.SupportVectorMachineUtil;

public class LibSVMRegressor
extends SkLearnRegressor
implements HasLibSVMKernel {
    public LibSVMRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getSupportVectorsShape();
        return shape[1];
    }

    public SupportVectorMachineModel encodeModel(Schema schema) {
        int[] shape = this.getSupportVectorsShape();
        int numberOfVectors = shape[0];
        int numberOfFeatures = shape[1];
        List<Integer> support = this.getSupport();
        List<Number> supportVectors = this.getSupportVectors();
        List<Number> dualCoef = this.getDualCoef();
        List<Number> intercept = this.getIntercept();
        Kernel kernel = SupportVectorMachineUtil.createKernel(this);
        return LibSVMUtil.createRegression((Kernel)kernel, (Matrix)new CMatrix(supportVectors, numberOfVectors, numberOfFeatures), SupportVectorMachineUtil.formatIds(support), (Number)((Number)Iterables.getOnlyElement(intercept)), dualCoef, (Schema)schema);
    }

    @Override
    public String getKernel() {
        return (String)this.getEnum("kernel", arg_0 -> ((LibSVMRegressor)this).getString(arg_0), ENUM_KERNEL);
    }

    @Override
    public Integer getDegree() {
        return this.getInteger("degree");
    }

    @Override
    public Number getGamma() {
        return this.getNumber("_gamma");
    }

    @Override
    public Number getCoef0() {
        return this.getNumber("coef0");
    }

    public List<Integer> getSupport() {
        return this.getIntegerArray("support_");
    }

    public List<Number> getSupportVectors() {
        return this.getNumberArray("support_vectors_");
    }

    public int[] getSupportVectorsShape() {
        return this.getArrayShape("support_vectors_", 2);
    }

    public List<Number> getDualCoef() {
        return this.getNumberArray("_dual_coef_");
    }

    public List<Number> getIntercept() {
        return this.getNumberArray("_intercept_");
    }
}

