/*
 * Decompiled with CFR 0.152.
 */
package sklearn.svm;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.dmg.pmml.support_vector_machine.LinearKernel;
import org.dmg.pmml.support_vector_machine.PolynomialKernel;
import org.dmg.pmml.support_vector_machine.RadialBasisKernel;
import org.dmg.pmml.support_vector_machine.SigmoidKernel;
import sklearn.svm.HasLibSVMKernel;

public class SupportVectorMachineUtil {
    private SupportVectorMachineUtil() {
    }

    public static List<String> formatIds(List<Integer> values) {
        Function<Integer, String> function = new Function<Integer, String>(){

            public String apply(Integer value) {
                return value.toString();
            }
        };
        return Lists.transform(values, (Function)function);
    }

    public static Kernel createKernel(HasLibSVMKernel hasLibSVMKernel) {
        String kernel;
        switch (kernel = hasLibSVMKernel.getKernel()) {
            case "linear": {
                return new LinearKernel();
            }
            case "poly": {
                Integer degree = hasLibSVMKernel.getDegree();
                Number gamma = hasLibSVMKernel.getGamma();
                Number coef0 = hasLibSVMKernel.getCoef0();
                return new PolynomialKernel().setGamma(gamma).setCoef0(coef0).setDegree((Number)degree);
            }
            case "rbf": {
                Number gamma = hasLibSVMKernel.getGamma();
                return new RadialBasisKernel().setGamma(gamma);
            }
            case "sigmoid": {
                Number gamma = hasLibSVMKernel.getGamma();
                Number coef0 = hasLibSVMKernel.getCoef0();
                return new SigmoidKernel().setGamma(gamma).setCoef0(coef0);
            }
        }
        throw new IllegalArgumentException(kernel);
    }
}

