/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.ensemble;

import java.util.List;
import java.util.Objects;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import sklearn.Classifier;
import sklearn.Estimator;
import sklearn.EstimatorUtil;
import sklearn.Transformer;
import sklearn2pmml.HasController;
import sklearn2pmml.ensemble.HasEstimatorSteps;
import sklearn2pmml.ensemble.SelectFirstUtil;

public class SelectFirstClassifier
extends Classifier
implements HasController,
HasEstimatorSteps {
    public SelectFirstClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public List<?> getClasses() {
        List estimators = this.getEstimators();
        List<?> result = null;
        for (Estimator estimator : estimators) {
            if (result == null) {
                result = EstimatorUtil.getClasses(estimator);
                continue;
            }
            if (Objects.equals(result, EstimatorUtil.getClasses(estimator))) continue;
            throw new IllegalArgumentException();
        }
        return result;
    }

    @Override
    public boolean hasProbabilityDistribution() {
        List estimators = this.getEstimators();
        boolean result = true;
        for (Estimator estimator : estimators) {
            result &= EstimatorUtil.hasProbabilityDistribution(estimator);
        }
        return result;
    }

    public MiningModel encodeModel(Schema schema) {
        return SelectFirstUtil.encodeSelectFirstEstimator(this, schema);
    }

    @Override
    public Transformer getController() {
        return (Transformer)this.getOptional("controller", Transformer.class);
    }

    @Override
    public List<Object[]> getSteps() {
        return this.getTupleList("steps");
    }
}

