/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import pandas.CategoricalDtypeUtil;
import pandas.core.CategoricalDtype;
import sklearn.Transformer;

public abstract class TypeTransformer
extends Transformer {
    public TypeTransformer(String module, String name) {
        super(module, name);
    }

    public Feature refineFeature(Feature feature, TypeInfo dtype, SkLearnEncoder encoder) {
        DataType dataType = dtype.getDataType();
        OpType opType = TypeUtil.getOpType((DataType)dataType);
        feature = this.refineFeature(feature, opType, dataType, encoder);
        if (dtype instanceof CategoricalDtype) {
            CategoricalDtype categoricalDtype = (CategoricalDtype)dtype;
            feature = CategoricalDtypeUtil.refineFeature(feature, categoricalDtype, encoder);
        }
        return feature;
    }

    public Feature refineFeature(Feature feature, OpType opType, DataType dataType, SkLearnEncoder encoder) {
        if (feature instanceof WildcardFeature) {
            WildcardFeature wildcardFeature = (WildcardFeature)feature;
            wildcardFeature = this.refineWildcardFeature(wildcardFeature, opType, dataType, encoder);
            DataField dataField = wildcardFeature.getField();
            switch (opType) {
                case CONTINUOUS: {
                    return new ContinuousFeature((PMMLEncoder)encoder, (Field)dataField);
                }
                case CATEGORICAL: 
                case ORDINAL: {
                    return new ObjectFeature((PMMLEncoder)encoder, (Field)dataField);
                }
            }
            throw new IllegalArgumentException();
        }
        if (feature.getDataType() != dataType) {
            FieldRef fieldRef = feature.ref();
            DerivedField derivedField = encoder.ensureDerivedField(this.createFieldName(dataType.name().toLowerCase(), feature), opType, dataType, () -> fieldRef);
            return FeatureUtil.createFeature((Field)derivedField, (PMMLEncoder)encoder);
        }
        return feature;
    }
}

