/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.PythonException;
import org.jpmml.sklearn.SkLearnEncoder;
import org.jpmml.sklearn.SkLearnException;

public class InitializerUtil {
    private InitializerUtil() {
    }

    public static Feature selectFeature(String column, List<Feature> features, SkLearnEncoder encoder) {
        List<Feature> result = InitializerUtil.selectFeatures(Collections.singletonList(column), features, encoder);
        return (Feature)Iterables.getOnlyElement(result);
    }

    public static List<Feature> selectFeatures(List<?> columns, final List<Feature> features, final SkLearnEncoder encoder) {
        Function<Object, Feature> castFunction = new Function<Object, Feature>(){

            public Feature apply(Object object) {
                if (object instanceof String) {
                    String column = (String)object;
                    if (!features.isEmpty()) {
                        Feature feature = FeatureUtil.findFeature((List)features, (String)column);
                        if (feature != null) {
                            return feature;
                        }
                        throw new SkLearnException("Column '" + column + "' not found in " + FeatureUtil.formatNames((List)features, (char)'\''));
                    }
                    return InitializerUtil.createWildcardFeature(column, encoder);
                }
                if (object instanceof Integer) {
                    Integer index = (Integer)object;
                    if (!features.isEmpty()) {
                        Feature feature = (Feature)features.get(index);
                        return feature;
                    }
                    return InitializerUtil.createWildcardFeature("x" + (index + 1), encoder);
                }
                throw new PythonException("The column object (" + ClassDictUtil.formatClass((Object)object) + ") is not a string nor integer");
            }
        };
        return Lists.transform(columns, (Function)castFunction);
    }

    public static Feature createWildcardFeature(String name, SkLearnEncoder encoder) {
        DataField dataField = encoder.getDataField(name);
        if (dataField == null) {
            dataField = encoder.createDataField(name);
        }
        return new WildcardFeature((PMMLEncoder)encoder, dataField);
    }
}

