/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import builtins.TypeConstructor;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.razorvine.pickle.objects.ClassDict;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.AttributeCastFunction;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.PythonTypeUtil;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasMultiType;
import sklearn.Step;
import sklearn.StepUtil;
import sklearn2pmml.HasPMMLName;

public abstract class Transformer
extends Step
implements HasPMMLName<Transformer> {
    public Transformer(String module, String name) {
        super(module, name);
    }

    public abstract List<Feature> encodeFeatures(List<Feature> var1, SkLearnEncoder var2);

    @Override
    public int getNumberOfFeatures() {
        if (this.hasattr("n_features_in_")) {
            return this.getInteger("n_features_in_");
        }
        return -1;
    }

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public DataType getDataType() {
        return DataType.DOUBLE;
    }

    public List<Feature> encode(List<Feature> features, SkLearnEncoder encoder) {
        this.checkVersion();
        this.checkFeatures(features);
        features = this.updateFeatures(features, encoder);
        return this.encodeFeatures(features, encoder);
    }

    public void checkFeatures(List<? extends Feature> features) {
        StepUtil.checkNumberOfFeatures(this, features);
    }

    public List<Feature> updateFeatures(List<Feature> features, SkLearnEncoder encoder) {
        HasMultiType hasMultiType = StepUtil.getType(this);
        ArrayList<Feature> result = new ArrayList<Feature>(features.size());
        for (int i = 0; i < features.size(); ++i) {
            Feature feature;
            block4: {
                feature = features.get(i);
                if (feature instanceof WildcardFeature) {
                    DataType dataType;
                    OpType opType;
                    WildcardFeature wildcardFeature = (WildcardFeature)feature;
                    try {
                        opType = hasMultiType.getOpType(i);
                        dataType = hasMultiType.getDataType(i);
                    }
                    catch (UnsupportedOperationException uoe) {
                        break block4;
                    }
                    feature = this.refineWildcardFeature(wildcardFeature, opType, dataType, encoder);
                }
            }
            result.add(feature);
        }
        return result;
    }

    public WildcardFeature refineWildcardFeature(WildcardFeature wildcardFeature, OpType opType, DataType dataType, SkLearnEncoder encoder) {
        String name = wildcardFeature.getName();
        DataField dataField = encoder.getDataField(name);
        if (dataField == null) {
            throw new IllegalArgumentException("Field " + name + " is undefined");
        }
        if (dataField.requireOpType() != opType || dataField.requireDataType() != dataType) {
            dataField = this.updateDataField(dataField, opType, dataType, encoder);
            wildcardFeature = new WildcardFeature((PMMLEncoder)encoder, dataField);
        }
        return wildcardFeature;
    }

    public DataField updateDataField(DataField dataField, OpType opType, DataType dataType, SkLearnEncoder encoder) {
        String name = dataField.requireName();
        if (encoder.isFrozen(name)) {
            return dataField;
        }
        switch (dataType) {
            case DOUBLE: {
                if (dataField.requireDataType() == DataType.DOUBLE) break;
                dataType = dataField.requireDataType();
            }
        }
        dataField.setOpType(opType).setDataType(dataType);
        return dataField;
    }

    public TypeInfo getDType(final String name, final boolean extended) {
        Object dtype = this.getObject(name);
        AttributeCastFunction<TypeInfo> castFunction = new AttributeCastFunction<TypeInfo>(TypeInfo.class){

            public TypeInfo apply(Object object) {
                object = Transformer.toTypeInfo(object, extended);
                return (TypeInfo)super.apply(object);
            }

            protected String formatMessage(Object object) {
                return "Data type attribute '" + ClassDictUtil.formatMember((ClassDict)Transformer.this, (String)name) + "' has an unsupported value (" + ClassDictUtil.formatClass((Object)object) + ")";
            }
        };
        return (TypeInfo)castFunction.apply(dtype);
    }

    public TypeInfo getOptionalDType(String name, boolean extended) {
        Object value = this.getOptionalObject(name);
        if (value == null) {
            return null;
        }
        return this.getDType(name, extended);
    }

    public List<TypeInfo> getDTypeList(final String name, final boolean extended) {
        List values = this.getList(name);
        AttributeCastFunction<TypeInfo> castFunction = new AttributeCastFunction<TypeInfo>(TypeInfo.class){

            public TypeInfo apply(Object object) {
                object = Transformer.toTypeInfo(object, extended);
                return (TypeInfo)super.apply(object);
            }

            protected String formatMessage(Object object) {
                return "List attribute '" + ClassDictUtil.formatMember((ClassDict)Transformer.this, (String)name) + "' contains an unsupported value (" + ClassDictUtil.formatClass((Object)object) + ")";
            }
        };
        return Lists.transform((List)values, (Function)castFunction);
    }

    public String createFieldName(String function, Object ... args) {
        return this.createFieldName(function, Arrays.asList(args));
    }

    public String createFieldName(String function, List<?> args) {
        String pmmlName = this.getPMMLName();
        if (pmmlName != null) {
            return pmmlName;
        }
        return FieldNameUtil.create((String)function, args);
    }

    @Override
    public Transformer setPMMLName(String pmmlName) {
        return (Transformer)super.setPMMLName(pmmlName);
    }

    private static Object toTypeInfo(Object object, boolean extended) {
        if (object instanceof TypeConstructor) {
            TypeConstructor typeConstructor = (TypeConstructor)object;
            return (TypeInfo)typeConstructor.construct();
        }
        if (object instanceof String) {
            final String string = (String)object;
            if (extended) {
                return new TypeInfo(){

                    public DataType getDataType() {
                        return PythonTypeUtil.parseDataType((String)string);
                    }
                };
            }
        }
        return object;
    }
}

