/*
 * Decompiled with CFR 0.152.
 */
package sklearn.model_selection;

import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Model;
import org.jpmml.converter.Schema;
import sklearn.Classifier;
import sklearn.HasEstimator;
import sklearn.SkLearnClassifier;
import sklearn.model_selection.ThresholdClassifierUtil;

public class TunedThresholdClassifierCV
extends SkLearnClassifier
implements HasEstimator<Classifier> {
    private static final String RESPONSEMETHOD_PREDICT_PROBA = "predict_proba";

    public TunedThresholdClassifierCV(String module, String name) {
        super(module, name);
    }

    @Override
    public List<?> getClasses() {
        Classifier estimator = this.getEstimator();
        return estimator.getClasses();
    }

    @Override
    public Model encodeModel(Schema schema) {
        Classifier estimator = this.getEstimator();
        String responseMethod = this.getResponseMethod();
        Number bestThreshold = this.getBestThreshold();
        return ThresholdClassifierUtil.encodeModel(estimator, bestThreshold, schema);
    }

    @Override
    public Classifier getEstimator() {
        return (Classifier)this.get("estimator_", Classifier.class);
    }

    public Number getBestThreshold() {
        return this.getNumber("best_threshold_");
    }

    public String getResponseMethod() {
        return (String)this.getEnum("response_method", arg_0 -> ((TunedThresholdClassifierCV)this).getString(arg_0), Arrays.asList(RESPONSEMETHOD_PREDICT_PROBA));
    }
}

