/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.evaluator;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionRegistry;

public class SparkMLFunctionRegistry {
    private static final Map<String, Function> functions = Collections.emptyMap();
    private static final Map<String, Class<? extends Function>> functionClazzes = Collections.emptyMap();

    private SparkMLFunctionRegistry() {
    }

    public static void publish(String name) {
        SparkMLFunctionRegistry.publish((String key) -> Objects.equals(name, key));
    }

    public static void publishAll() {
        SparkMLFunctionRegistry.publish((String key) -> true);
    }

    private static void publish(Predicate<String> predicate) {
        functions.entrySet().stream().filter(entry -> predicate.test((String)entry.getKey())).forEach(entry -> FunctionRegistry.putFunction((String)((String)entry.getKey()), (Function)((Function)entry.getValue())));
        functionClazzes.entrySet().stream().filter(entry -> predicate.test((String)entry.getKey())).forEach(entry -> FunctionRegistry.putFunction((String)((String)entry.getKey()), (Class)((Class)entry.getValue())));
    }
}

