/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.xgboost;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import ml.dmlc.xgboost4j.scala.Booster;
import ml.dmlc.xgboost4j.scala.spark.params.GeneralParams;
import org.apache.spark.ml.Model;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import org.jpmml.sparkml.ModelConverter;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.XGBoostUtil;

public class BoosterUtil {
    private BoosterUtil() {
    }

    public static <M extends Model<M> & GeneralParams, C extends ModelConverter<M>> MiningModel encodeBooster(C converter, Booster booster, Schema schema) {
        Learner learner;
        Model model = converter.getModel();
        try {
            File tmpBoosterFile = File.createTempFile("Booster", ".json");
            booster.saveModel(tmpBoosterFile.getAbsolutePath());
            try (FileInputStream is = new FileInputStream(tmpBoosterFile);){
                learner = XGBoostUtil.loadLearner((InputStream)is);
            }
            MoreFiles.deleteRecursively((Path)tmpBoosterFile.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Float missing = Float.valueOf(((GeneralParams)model).getMissing());
        if (missing.isNaN()) {
            missing = null;
        }
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        options.put("missing", converter.getOption("missing", (Object)missing));
        options.put("compact", converter.getOption("compact", (Object)false));
        options.put("input_float", converter.getOption("input_float", null));
        options.put("numeric", converter.getOption("numeric", (Object)true));
        options.put("prune", converter.getOption("prune", (Object)false));
        options.put("ntree_limit", converter.getOption("ntree_limit", null));
        Schema xgbSchema = learner.toXGBoostSchema(schema);
        return learner.encodeModel(options, xgbSchema);
    }
}

