/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.xgboost;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.function.Function;
import ml.dmlc.xgboost4j.scala.Booster;
import org.dmg.pmml.DataType;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Schema;
import org.jpmml.sparkml.ModelConverter;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.XGBoostUtil;

public class BoosterUtil {
    private BoosterUtil() {
    }

    public static <C extends ModelConverter<?>> MiningModel encodeBooster(C converter, Booster booster, Schema schema) {
        Learner learner;
        byte[] bytes;
        try {
            bytes = booster.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            learner = XGBoostUtil.loadLearner((InputStream)is);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Function<Feature, Feature> function = new Function<Feature, Feature>(){

            @Override
            public Feature apply(Feature feature) {
                if (feature instanceof BinaryFeature) {
                    BinaryFeature binaryFeature = (BinaryFeature)feature;
                    return binaryFeature;
                }
                ContinuousFeature continuousFeature = feature.toContinuousFeature(DataType.FLOAT);
                return continuousFeature;
            }
        };
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        options.put("compact", converter.getOption("compact", (Object)false));
        options.put("ntree_limit", converter.getOption("ntree_limit", null));
        Schema xgbSchema = schema.toTransformedSchema((Function)function);
        return learner.encodeMiningModel(options, xgbSchema);
    }
}

