/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.List;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasInputCols;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasOutputCols;
import org.jpmml.converter.Feature;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.sparkml.SparkMLEncoder;
import org.jpmml.sparkml.TransformerConverter;

public abstract class FeatureConverter<T extends Transformer>
extends TransformerConverter<T> {
    public FeatureConverter(T transformer) {
        super(transformer);
    }

    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        throw new UnsupportedOperationException();
    }

    public void registerFeatures(SparkMLEncoder encoder) {
        Object transformer = this.getTransformer();
        InOutMode outputMode = this.getOutputMode();
        if (outputMode == InOutMode.SINGLE) {
            HasOutputCol hasOutputCol = (HasOutputCol)transformer;
            String outputCol = hasOutputCol.getOutputCol();
            List<Feature> features = this.encodeFeatures(encoder);
            encoder.putFeatures(outputCol, features);
        } else if (outputMode == InOutMode.MULTIPLE) {
            HasOutputCols hasOutputCols = (HasOutputCols)transformer;
            String[] outputCols = hasOutputCols.getOutputCols();
            List<Feature> features = this.encodeFeatures(encoder);
            SchemaUtil.checkSize((int)outputCols.length, features);
            for (int i = 0; i < outputCols.length; ++i) {
                String outputCol = outputCols[i];
                Feature feature = features.get(i);
                encoder.putOnlyFeature(outputCol, feature);
            }
        }
    }

    protected InOutMode getInputMode() {
        throw new IllegalArgumentException();
    }

    protected InOutMode getOutputMode() {
        Object transformer = this.getTransformer();
        return FeatureConverter.getOutputMode(transformer);
    }

    public static <T extends Transformer> String formatName(T transformer) {
        return ((HasOutputCol)transformer).getOutputCol();
    }

    public static <T extends Transformer> String formatName(T transformer, int index, int length) {
        if (length > 1) {
            return ((HasOutputCol)transformer).getOutputCol() + "[" + index + "]";
        }
        return ((HasOutputCol)transformer).getOutputCol();
    }

    protected static <T extends HasInputCol & HasInputCols> InOutMode getInputMode(T transformer) {
        if (transformer.isSet(transformer.inputCol())) {
            return InOutMode.SINGLE;
        }
        if (transformer.isSet((Param)((HasInputCols)transformer).inputCols())) {
            return InOutMode.MULTIPLE;
        }
        throw new IllegalArgumentException();
    }

    protected static <T extends Transformer> InOutMode getOutputMode(T transformer) {
        if (transformer instanceof HasOutputCol) {
            return InOutMode.SINGLE;
        }
        if (transformer instanceof HasOutputCols) {
            return InOutMode.MULTIPLE;
        }
        return null;
    }

    public static enum InOutMode {
        SINGLE{

            @Override
            public <T extends Transformer & HasInputCols> String[] getInputCols(T transformer) {
                return new String[]{((HasInputCol)transformer).getInputCol()};
            }

            @Override
            public <T extends Transformer> String[] getOutputCols(T transformer) {
                if (transformer instanceof HasOutputCol) {
                    HasOutputCol hasOutputCol = (HasOutputCol)transformer;
                    return new String[]{hasOutputCol.getOutputCol()};
                }
                throw new IllegalArgumentException();
            }
        }
        ,
        MULTIPLE{

            @Override
            public <T extends Transformer & HasInputCols> String[] getInputCols(T transformer) {
                return ((HasInputCols)transformer).getInputCols();
            }

            @Override
            public <T extends Transformer> String[] getOutputCols(T transformer) {
                if (transformer instanceof HasOutputCols) {
                    HasOutputCols hasOutputCols = (HasOutputCols)transformer;
                    return hasOutputCols.getOutputCols();
                }
                throw new IllegalArgumentException();
            }
        };


        public abstract <T extends Transformer & HasInputCols> String[] getInputCols(T var1);

        public abstract <T extends Transformer> String[] getOutputCols(T var1);
    }
}

