/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import com.google.common.io.ByteStreams;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.SparkSession;

public class PipelineModelUtil {
    private PipelineModelUtil() {
    }

    public static PipelineModel load(SparkSession sparkSession, File dir) throws IOException {
        MLReader mlReader = PipelineModel.read();
        mlReader.session(sparkSession);
        return (PipelineModel)mlReader.load(dir.getAbsolutePath());
    }

    public static PipelineModel loadZip(SparkSession sparkSession, File file) throws IOException {
        File tmpDir = PipelineModelUtil.uncompress(file);
        PipelineModel pipelineModel = PipelineModelUtil.load(sparkSession, tmpDir);
        MoreFiles.deleteRecursively((Path)tmpDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
        return pipelineModel;
    }

    public static void store(PipelineModel pipelineModel, File dir) throws IOException {
        PipelineModel.PipelineModelWriter mlWriter = new PipelineModel.PipelineModelWriter(pipelineModel);
        mlWriter.save(dir.getAbsolutePath());
    }

    public static void storeZip(PipelineModel pipelineModel, File file) throws IOException {
        File tmpDir = File.createTempFile("PipelineModel", "");
        if (!tmpDir.delete()) {
            throw new IOException();
        }
        PipelineModelUtil.store(pipelineModel, tmpDir);
        PipelineModelUtil.compress(tmpDir, file);
        MoreFiles.deleteRecursively((Path)tmpDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
    }

    public static void compress(File dir, File file) throws IOException {
        final Path dirPath = Paths.get(dir.getAbsolutePath(), new String[0]);
        try (FileOutputStream os = new FileOutputStream(file);){
            final ZipOutputStream zos = new ZipOutputStream(os);
            SimpleFileVisitor<Path> dirFileVisitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes mainAtts) throws IOException {
                    File dirFile = path.toFile();
                    Path relativePath = dirPath.relativize(path);
                    ZipEntry entry = new ZipEntry(relativePath.toString());
                    entry.setSize(dirFile.length());
                    entry.setTime(dirFile.lastModified());
                    zos.putNextEntry(entry);
                    try (FileInputStream is = new FileInputStream(dirFile);){
                        ByteStreams.copy((InputStream)is, (OutputStream)zos);
                    }
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            };
            Files.walkFileTree(dirPath, (FileVisitor<? super Path>)dirFileVisitor);
            zos.finish();
        }
    }

    public static File uncompress(File file) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            File tmpDir = File.createTempFile("PipelineModel", "");
            if (!tmpDir.delete()) {
                throw new IOException();
            }
            tmpDir.mkdirs();
            PipelineModelUtil.uncompress(zipFile, tmpDir);
            File file2 = tmpDir;
            return file2;
        }
    }

    public static void uncompress(File file, File dir) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            PipelineModelUtil.uncompress(zipFile, dir);
        }
    }

    private static void uncompress(ZipFile zipFile, File dir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            InputStream is = zipFile.getInputStream(entry);
            Throwable throwable = null;
            try {
                File file = new File(dir, entry.getName());
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdirs()) {
                    throw new IOException(parentDir.getAbsolutePath());
                }
                FileOutputStream os = new FileOutputStream(file);
                Throwable throwable2 = null;
                try {
                    ByteStreams.copy((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (os == null) continue;
                    if (throwable2 != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    ((OutputStream)os).close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                is.close();
            }
        }
    }
}

