/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.MinMaxScalerModel;
import org.apache.spark.ml.linalg.Vector;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class MinMaxScalerModelConverter
extends FeatureConverter<MinMaxScalerModel> {
    public MinMaxScalerModelConverter(MinMaxScalerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        MinMaxScalerModel transformer = (MinMaxScalerModel)this.getTransformer();
        double rescaleFactor = transformer.getMax() - transformer.getMin();
        double rescaleConstant = transformer.getMin();
        Vector originalMin = transformer.originalMin();
        Vector originalMax = transformer.originalMax();
        List<Feature> features = encoder.getFeatures(transformer.getInputCol());
        SchemaUtil.checkSize((int)Math.max(originalMin.size(), originalMax.size()), features);
        ArrayList<Feature> result = new ArrayList<Feature>();
        int length = features.size();
        for (int i = 0; i < length; ++i) {
            Feature feature = features.get(i);
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            double min = originalMin.apply(i);
            double max = originalMax.apply(i);
            Apply expression = ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"-", (Expression[])new Expression[]{continuousFeature.ref(), ExpressionUtil.createConstant((Number)min)}), ExpressionUtil.createConstant((Number)(max - min))});
            if (!ValueUtil.isOne((Number)rescaleFactor)) {
                expression = ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{expression, ExpressionUtil.createConstant((Number)rescaleFactor)});
            }
            if (!ValueUtil.isZero((Number)rescaleConstant)) {
                expression = ExpressionUtil.createApply((String)"+", (Expression[])new Expression[]{expression, ExpressionUtil.createConstant((Number)rescaleConstant)});
            }
            DerivedField derivedField = encoder.createDerivedField(MinMaxScalerModelConverter.formatName(transformer, i, length), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)expression);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }
}

