/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.dmg.pmml.Model;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Schema;
import org.jpmml.sparkml.ProbabilisticClassificationModelConverter;
import org.jpmml.sparkml.model.HasRegressionTableOptions;
import org.jpmml.sparkml.model.LinearModelUtil;

public class LogisticRegressionModelConverter
extends ProbabilisticClassificationModelConverter<LogisticRegressionModel>
implements HasRegressionTableOptions {
    public LogisticRegressionModelConverter(LogisticRegressionModel model) {
        super(model);
    }

    @Override
    public Model encodeModel(Schema schema) {
        LogisticRegressionModel model = (LogisticRegressionModel)this.getModel();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        if (categoricalLabel.size() == 2) {
            Model linearModel = LinearModelUtil.createBinaryLogisticClassification(this, model.coefficients(), model.intercept(), schema).setOutput(null);
            return linearModel;
        }
        if (categoricalLabel.size() > 2) {
            Model linearModel = LinearModelUtil.createSoftmaxClassification(this, model.coefficientMatrix(), model.interceptVector(), schema).setOutput(null);
            return linearModel;
        }
        throw new IllegalArgumentException();
    }
}

