/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.visitors;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.visitors.AbstractTreeModelTransformer;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.model.UnsupportedElementException;

public class TreeModelCompactor
extends AbstractTreeModelTransformer {
    private MiningFunction miningFunction = null;
    private Map<Node, SimpleSetPredicate> replacedPredicates = new IdentityHashMap<Node, SimpleSetPredicate>();

    public void enterNode(Node node) {
        Object id = node.getId();
        Object score = node.getScore();
        if (id != null) {
            throw new UnsupportedElementException((PMMLObject)node);
        }
        if (node.hasNodes()) {
            List children = node.getNodes();
            if (score != null || children.size() != 2) {
                throw new UnsupportedElementException((PMMLObject)node);
            }
            Node firstChild = (Node)children.get(0);
            Node secondChild = (Node)children.get(1);
            org.dmg.pmml.Predicate firstPredicate = firstChild.requirePredicate();
            org.dmg.pmml.Predicate secondPredicate = secondChild.requirePredicate();
            TreeModelCompactor.checkFieldReference((org.dmg.pmml.Predicate)firstPredicate, (org.dmg.pmml.Predicate)secondPredicate);
            boolean update = true;
            if (TreeModelCompactor.hasOperator((org.dmg.pmml.Predicate)firstPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.EQUAL) && TreeModelCompactor.hasOperator((org.dmg.pmml.Predicate)secondPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.EQUAL)) {
                update = this.isCategoricalField((HasFieldReference<?>)((SimplePredicate)firstPredicate));
            } else if (TreeModelCompactor.hasOperator((org.dmg.pmml.Predicate)firstPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.NOT_EQUAL) && TreeModelCompactor.hasOperator((org.dmg.pmml.Predicate)secondPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.EQUAL)) {
                children = TreeModelCompactor.swapChildren((Node)node);
                firstChild = (Node)children.get(0);
                secondChild = (Node)children.get(1);
            } else if (!(TreeModelCompactor.hasOperator((org.dmg.pmml.Predicate)firstPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.EQUAL) && TreeModelCompactor.hasOperator((org.dmg.pmml.Predicate)secondPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.NOT_EQUAL) || TreeModelCompactor.hasOperator((org.dmg.pmml.Predicate)firstPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.LESS_OR_EQUAL) && TreeModelCompactor.hasOperator((org.dmg.pmml.Predicate)secondPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.GREATER_THAN))) {
                if (TreeModelCompactor.hasOperator((org.dmg.pmml.Predicate)firstPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.EQUAL) && TreeModelCompactor.hasBooleanOperator((org.dmg.pmml.Predicate)secondPredicate, (SimpleSetPredicate.BooleanOperator)SimpleSetPredicate.BooleanOperator.IS_IN)) {
                    this.addCategoricalField(secondChild);
                } else if (TreeModelCompactor.hasBooleanOperator((org.dmg.pmml.Predicate)firstPredicate, (SimpleSetPredicate.BooleanOperator)SimpleSetPredicate.BooleanOperator.IS_IN) && TreeModelCompactor.hasOperator((org.dmg.pmml.Predicate)secondPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.EQUAL)) {
                    children = TreeModelCompactor.swapChildren((Node)node);
                    firstChild = (Node)children.get(0);
                    secondChild = (Node)children.get(1);
                    this.addCategoricalField(secondChild);
                } else if (TreeModelCompactor.hasBooleanOperator((org.dmg.pmml.Predicate)firstPredicate, (SimpleSetPredicate.BooleanOperator)SimpleSetPredicate.BooleanOperator.IS_IN) && TreeModelCompactor.hasBooleanOperator((org.dmg.pmml.Predicate)secondPredicate, (SimpleSetPredicate.BooleanOperator)SimpleSetPredicate.BooleanOperator.IS_IN)) {
                    this.addCategoricalField(secondChild);
                } else {
                    throw new UnsupportedElementException((PMMLObject)node);
                }
            }
            if (update) {
                secondChild.setPredicate((org.dmg.pmml.Predicate)True.INSTANCE);
            }
        } else if (score == null) {
            throw new UnsupportedElementException((PMMLObject)node);
        }
    }

    public void exitNode(Node node) {
        org.dmg.pmml.Predicate predicate = node.requirePredicate();
        if (predicate instanceof True) {
            Node parentNode = this.getParentNode();
            if (parentNode == null) {
                return;
            }
            if (this.miningFunction == MiningFunction.REGRESSION) {
                TreeModelCompactor.initScore((Node)parentNode, (Node)node);
                TreeModelCompactor.replaceChildWithGrandchildren((Node)parentNode, (Node)node);
            } else if (this.miningFunction == MiningFunction.CLASSIFICATION && node.hasNodes()) {
                TreeModelCompactor.replaceChildWithGrandchildren((Node)parentNode, (Node)node);
            }
        }
    }

    public void enterTreeModel(TreeModel treeModel) {
        super.enterTreeModel(treeModel);
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        if (missingValueStrategy != TreeModel.MissingValueStrategy.NONE) {
            throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)missingValueStrategy);
        }
        TreeModel.NoTrueChildStrategy noTrueChildStrategy = treeModel.getNoTrueChildStrategy();
        if (noTrueChildStrategy != TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION) {
            throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)noTrueChildStrategy);
        }
        TreeModel.SplitCharacteristic splitCharacteristic = treeModel.getSplitCharacteristic();
        if (splitCharacteristic != TreeModel.SplitCharacteristic.BINARY_SPLIT) {
            throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)splitCharacteristic);
        }
        treeModel.setMissingValueStrategy(TreeModel.MissingValueStrategy.NULL_PREDICTION).setSplitCharacteristic(TreeModel.SplitCharacteristic.MULTI_SPLIT);
        MiningFunction miningFunction = treeModel.requireMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                treeModel.setNoTrueChildStrategy(TreeModel.NoTrueChildStrategy.RETURN_LAST_PREDICTION);
                break;
            }
            case CLASSIFICATION: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)miningFunction);
            }
        }
        this.miningFunction = miningFunction;
        this.replacedPredicates.clear();
    }

    public void exitTreeModel(TreeModel treeModel) {
        super.exitTreeModel(treeModel);
        this.miningFunction = null;
    }

    private boolean isCategoricalField(HasFieldReference<?> hasFieldReference) {
        final String name = hasFieldReference.requireField();
        Predicate<Node> predicate = new Predicate<Node>(){

            @Override
            public boolean test(Node node) {
                org.dmg.pmml.Predicate predicate = node.requirePredicate();
                if (predicate instanceof True) {
                    predicate = (org.dmg.pmml.Predicate)TreeModelCompactor.this.replacedPredicates.get(node);
                }
                if (predicate instanceof SimpleSetPredicate) {
                    SimpleSetPredicate simpleSetPredicate = (SimpleSetPredicate)predicate;
                    return TreeModelCompactor.hasFieldReference((org.dmg.pmml.Predicate)((org.dmg.pmml.Predicate)simpleSetPredicate), (String)name);
                }
                return false;
            }
        };
        Node ancestorNode = this.getAncestorNode(predicate);
        return ancestorNode != null;
    }

    private void addCategoricalField(Node node) {
        this.replacedPredicates.put(node, (SimpleSetPredicate)node.requirePredicate(SimpleSetPredicate.class));
    }
}

