/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.linalg.Matrix;

public class MatrixUtil {
    private MatrixUtil() {
    }

    public void checkColumns(int columns, Matrix matrix) {
        if (matrix.numCols() != columns) {
            throw new IllegalArgumentException("Expected " + columns + " column(s), got " + matrix.numCols() + " column(s)");
        }
    }

    public static void checkRows(int rows, Matrix matrix) {
        if (matrix.numRows() != rows) {
            throw new IllegalArgumentException("Expected " + rows + " row(s), got " + matrix.numRows() + " row(s)");
        }
    }

    public static List<Double> getRow(Matrix matrix, int row) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int column = 0; column < matrix.numCols(); ++column) {
            result.add(matrix.apply(row, column));
        }
        return result;
    }

    public static List<Double> getColumn(Matrix matrix, int column) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int row = 0; row < matrix.numRows(); ++row) {
            result.add(matrix.apply(row, column));
        }
        return result;
    }
}

