/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.List;
import org.apache.spark.ml.Model;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.sparkml.SparkMLEncoder;
import org.jpmml.sparkml.TransformerConverter;

public abstract class ModelConverter<T extends Model<T>>
extends TransformerConverter<T> {
    public ModelConverter(T model) {
        super(model);
    }

    public abstract MiningFunction getMiningFunction();

    public abstract List<Feature> getFeatures(SparkMLEncoder var1);

    public abstract org.dmg.pmml.Model encodeModel(Schema var1);

    public Schema encodeSchema(SparkMLEncoder encoder) {
        Label label = this.getLabel(encoder);
        List<Feature> features = this.getFeatures(encoder);
        Schema result = new Schema((ModelEncoder)encoder, label, features);
        this.checkSchema(result);
        return result;
    }

    public Label getLabel(SparkMLEncoder encoder) {
        return null;
    }

    public void checkSchema(Schema schema) {
        ScalarLabel scalarLabel;
        Feature labelFeature;
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        MiningFunction miningFunction = this.getMiningFunction();
        switch (miningFunction) {
            case ASSOCIATION_RULES: 
            case CLUSTERING: {
                if (label == null) break;
                throw new IllegalArgumentException("Expected no label, got " + label);
            }
            case CLASSIFICATION: 
            case REGRESSION: {
                if (label != null) break;
                throw new IllegalArgumentException("Expected a label, got no label");
            }
        }
        if (label instanceof ScalarLabel && (labelFeature = FeatureUtil.findLabelFeature((List)features, (ScalarLabel)(scalarLabel = (ScalarLabel)label))) != null) {
            throw new IllegalArgumentException("Label column '" + scalarLabel.getName() + "' is contained in the list of feature columns");
        }
    }

    public List<OutputField> registerOutputFields(Label label, org.dmg.pmml.Model model, SparkMLEncoder encoder) {
        return null;
    }

    public org.dmg.pmml.Model registerModel(SparkMLEncoder encoder) {
        org.dmg.pmml.Model model;
        Schema schema = this.encodeSchema(encoder);
        Label label = schema.getLabel();
        List<OutputField> sparkOutputFields = this.registerOutputFields(label, model = this.encodeModel(schema), encoder);
        if (sparkOutputFields != null && !sparkOutputFields.isEmpty()) {
            org.dmg.pmml.Model finalModel = MiningModelUtil.getFinalModel((org.dmg.pmml.Model)model);
            Output output = ModelUtil.ensureOutput((org.dmg.pmml.Model)finalModel);
            List outputFields = output.getOutputFields();
            outputFields.addAll(sparkOutputFields);
        }
        return model;
    }

    public T getModel() {
        return (T)((Model)this.getObject());
    }
}

