/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.spark.ml.feature.StandardScalerModel;
import org.apache.spark.ml.linalg.Vector;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ProductFeature;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class StandardScalerModelConverter
extends FeatureConverter<StandardScalerModel> {
    public StandardScalerModelConverter(StandardScalerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        StandardScalerModel transformer = (StandardScalerModel)this.getTransformer();
        Vector mean = transformer.mean();
        Vector std = transformer.std();
        boolean withMean = transformer.getWithMean();
        boolean withStd = transformer.getWithStd();
        List<Feature> features = encoder.getFeatures(transformer.getInputCol());
        if (withMean) {
            SchemaUtil.checkSize((int)mean.size(), features);
        }
        if (withStd) {
            SchemaUtil.checkSize((int)std.size(), features);
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        int length = features.size();
        for (int i = 0; i < length; ++i) {
            double stdValue;
            double meanValue;
            Object feature = features.get(i);
            final String name = StandardScalerModelConverter.formatName(transformer, i, length);
            Apply expression = null;
            if (withMean && !ValueUtil.isZero((Number)(meanValue = mean.apply(i)))) {
                ContinuousFeature continuousFeature = feature.toContinuousFeature();
                expression = PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{continuousFeature.ref(), PMMLUtil.createConstant((Number)meanValue)});
            }
            if (withStd && !ValueUtil.isOne((Number)(stdValue = std.apply(i)))) {
                Double factor = 1.0 / stdValue;
                if (expression != null) {
                    expression = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)factor)});
                } else {
                    feature = new ProductFeature((PMMLEncoder)encoder, (Feature)feature, factor){

                        public ContinuousFeature toContinuousFeature() {
                            Supplier<Apply> applySupplier = () -> {
                                Feature feature = this.getFeature();
                                Number factor = this.getFactor();
                                return PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{feature.toContinuousFeature().ref(), PMMLUtil.createConstant((Number)factor)});
                            };
                            return this.toContinuousFeature(name, DataType.DOUBLE, applySupplier);
                        }
                    };
                }
            }
            if (expression != null) {
                DerivedField derivedField = encoder.createDerivedField(name, OpType.CONTINUOUS, DataType.DOUBLE, (Expression)expression);
                result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
                continue;
            }
            result.add((Feature)feature);
        }
        return result;
    }
}

