/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.Objects;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.model.ToStringHelper;
import org.jpmml.sparkml.TermFeature;

public class WeightedTermFeature
extends TermFeature {
    private Number weight = null;

    public WeightedTermFeature(PMMLEncoder encoder, DefineFunction defineFunction, Feature feature, String value, Number weight) {
        super(encoder, defineFunction, feature, value);
        this.setWeight(weight);
    }

    @Override
    public Apply createApply() {
        Number weight = this.getWeight();
        Apply apply = super.createApply().addExpressions(new Expression[]{ExpressionUtil.createConstant((Number)weight)});
        return apply;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.getWeight());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof WeightedTermFeature) {
            WeightedTermFeature that = (WeightedTermFeature)((Object)object);
            return super.equals(object) && Objects.equals(this.getWeight(), that.getWeight());
        }
        return false;
    }

    @Override
    protected ToStringHelper toStringHelper() {
        return super.toStringHelper().add("weight", (Object)this.getWeight());
    }

    public Number getWeight() {
        return this.weight;
    }

    private void setWeight(Number weight) {
        this.weight = Objects.requireNonNull(weight);
    }
}

