/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.InvalidValueDecorator;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.MultiFeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class StringIndexerModelConverter
extends MultiFeatureConverter<StringIndexerModel> {
    public StringIndexerModelConverter(StringIndexerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        StringIndexerModel transformer = (StringIndexerModel)this.getTransformer();
        String handleInvalid = transformer.getHandleInvalid();
        String[][] labelsArray = transformer.labelsArray();
        FeatureConverter.InOutMode inputMode = this.getInputMode();
        ArrayList<Feature> result = new ArrayList<Feature>();
        String[] inputCols = inputMode.getInputCols(transformer);
        for (int i = 0; i < inputCols.length; ++i) {
            String inputCol = inputCols[i];
            String[] labels = labelsArray[i];
            Feature feature = encoder.getOnlyFeature(inputCol);
            DataType dataType = feature.getDataType();
            ArrayList<String> categories = new ArrayList<String>();
            categories.addAll(Arrays.asList(labels));
            String invalidCategory = StringIndexerModelConverter.getInvalidCategory(dataType);
            Field field = encoder.toCategorical(feature.getName(), categories);
            if (field instanceof DataField) {
                InvalidValueDecorator invalidValueDecorator;
                DataField dataField = (DataField)field;
                switch (handleInvalid) {
                    case "keep": {
                        invalidValueDecorator = new InvalidValueDecorator(InvalidValueTreatmentMethod.AS_VALUE, (Object)invalidCategory);
                        categories.add(invalidCategory);
                        break;
                    }
                    case "error": {
                        invalidValueDecorator = new InvalidValueDecorator(InvalidValueTreatmentMethod.RETURN_INVALID, null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid value handling strategy " + handleInvalid + " is not supported");
                    }
                }
                encoder.addDecorator((Field)dataField, (Decorator)invalidValueDecorator);
            } else if (field instanceof DerivedField) {
                switch (handleInvalid) {
                    case "keep": {
                        FieldRef fieldRef = feature.ref();
                        Apply apply = ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionUtil.createValueApply((Expression)fieldRef, (DataType)dataType, categories), fieldRef, ExpressionUtil.createConstant((DataType)dataType, (Object)invalidCategory)});
                        categories.add(invalidCategory);
                        field = encoder.createDerivedField(FieldNameUtil.create((String)"handleInvalid", (Object[])new Object[]{feature}), OpType.CATEGORICAL, dataType, (Expression)apply);
                        break;
                    }
                    case "error": {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(handleInvalid);
                    }
                }
            } else {
                throw new IllegalArgumentException();
            }
            result.add((Feature)new CategoricalFeature((PMMLEncoder)encoder, field, categories));
        }
        return result;
    }

    public static String getInvalidCategory(DataType dataType) {
        switch (dataType) {
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                return "-999";
            }
        }
        return "__unknown";
    }
}

