/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.SparkSession;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.sparkml.ArchiveUtil;

public class PipelineModelUtil {
    private static final Field FIELD_STAGES = ReflectionUtil.getField(PipelineModel.class, (String)"stages");

    private PipelineModelUtil() {
    }

    public static void addStage(PipelineModel pipelineModel, int index, Transformer transformer) {
        ArrayList<Transformer> stages = new ArrayList<Transformer>(Arrays.asList(pipelineModel.stages()));
        stages.add(index, transformer);
        ReflectionUtil.setFieldValue((Field)FIELD_STAGES, (Object)pipelineModel, (Object)stages.toArray(new Transformer[stages.size()]));
    }

    public static Transformer removeStage(PipelineModel pipelineModel, int index) {
        ArrayList<Transformer> stages = new ArrayList<Transformer>(Arrays.asList(pipelineModel.stages()));
        Transformer result = (Transformer)stages.remove(index);
        ReflectionUtil.setFieldValue((Field)FIELD_STAGES, (Object)pipelineModel, (Object)stages.toArray(new Transformer[stages.size()]));
        return result;
    }

    public static PipelineModel load(SparkSession sparkSession, File dir) throws IOException {
        MLReader mlReader = PipelineModel.read();
        mlReader.session(sparkSession);
        return (PipelineModel)mlReader.load(dir.getAbsolutePath());
    }

    public static PipelineModel loadZip(SparkSession sparkSession, File file) throws IOException {
        File tmpDir = ArchiveUtil.uncompress(file);
        PipelineModel pipelineModel = PipelineModelUtil.load(sparkSession, tmpDir);
        MoreFiles.deleteRecursively((Path)tmpDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
        return pipelineModel;
    }

    public static void store(PipelineModel pipelineModel, File dir) throws IOException {
        PipelineModel.PipelineModelWriter mlWriter = new PipelineModel.PipelineModelWriter(pipelineModel);
        mlWriter.save(dir.getAbsolutePath());
    }

    public static void storeZip(PipelineModel pipelineModel, File file) throws IOException {
        File tmpDir = File.createTempFile("PipelineModel", "");
        if (!tmpDir.delete()) {
            throw new IOException();
        }
        PipelineModelUtil.store(pipelineModel, tmpDir);
        ArchiveUtil.compress(tmpDir, file);
        MoreFiles.deleteRecursively((Path)tmpDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
    }
}

