/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.spark.ml.feature.OneHotEncoderModel;
import org.dmg.pmml.DataType;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.sparkml.BinarizedCategoricalFeature;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.MultiFeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;
import org.jpmml.sparkml.feature.StringIndexerModelConverter;

public class OneHotEncoderModelConverter
extends MultiFeatureConverter<OneHotEncoderModel> {
    public OneHotEncoderModelConverter(OneHotEncoderModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        String[] inputCols;
        OneHotEncoderModel transformer = (OneHotEncoderModel)this.getTransformer();
        boolean dropLast = transformer.getDropLast();
        String handleInvalid = transformer.getHandleInvalid();
        boolean keepInvalid = Objects.equals("keep", handleInvalid);
        FeatureConverter.InOutMode inputMode = this.getInputMode();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (String inputCol : inputCols = inputMode.getInputCols(transformer)) {
            CategoricalFeature categoricalFeature = (CategoricalFeature)encoder.getOnlyFeature(inputCol);
            DataType dataType = categoricalFeature.getDataType();
            String invalidCategory = StringIndexerModelConverter.getInvalidCategory(dataType);
            List values = categoricalFeature.getValues();
            List<BinaryFeature> binaryFeatures = OneHotEncoderModelConverter.encodeFeature((PMMLEncoder)encoder, (Feature)categoricalFeature, values);
            if (!dropLast && keepInvalid) {
                BinaryFeature invalidCategoryFeature = new BinaryFeature((PMMLEncoder)encoder, (Feature)categoricalFeature, (Object)invalidCategory);
                binaryFeatures.add(invalidCategoryFeature);
            } else if (dropLast && !keepInvalid) {
                binaryFeatures = binaryFeatures.subList(0, binaryFeatures.size() - 1);
            }
            result.add(new BinarizedCategoricalFeature((PMMLEncoder)encoder, categoricalFeature, binaryFeatures));
        }
        return result;
    }

    @Override
    public void registerFeatures(SparkMLEncoder encoder) {
        OneHotEncoderModel transformer = (OneHotEncoderModel)this.getTransformer();
        List<Feature> features = this.encodeFeatures(encoder);
        FeatureConverter.InOutMode outputMode = this.getOutputMode();
        if (outputMode == FeatureConverter.InOutMode.SINGLE) {
            String outputCol = transformer.getOutputCol();
            BinarizedCategoricalFeature binarizedCategoricalFeature = (BinarizedCategoricalFeature)((Object)Iterables.getOnlyElement(features));
            encoder.putFeatures(outputCol, binarizedCategoricalFeature.getBinaryFeatures());
        } else if (outputMode == FeatureConverter.InOutMode.MULTIPLE) {
            String[] outputCols = transformer.getOutputCols();
            SchemaUtil.checkSize((int)outputCols.length, features);
            for (int i = 0; i < outputCols.length; ++i) {
                String outputCol = outputCols[i];
                Feature feature = features.get(i);
                BinarizedCategoricalFeature binarizedCategoricalFeature = (BinarizedCategoricalFeature)feature;
                encoder.putFeatures(outputCol, binarizedCategoricalFeature.getBinaryFeatures());
            }
        }
    }

    public static List<BinaryFeature> encodeFeature(PMMLEncoder encoder, Feature feature, List<?> values) {
        ArrayList<BinaryFeature> result = new ArrayList<BinaryFeature>();
        for (Object value : values) {
            result.add(new BinaryFeature(encoder, feature, value));
        }
        return result;
    }
}

