/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class VectorIndexerModelConverter
extends FeatureConverter<VectorIndexerModel> {
    private static final Comparator<Map.Entry<Double, Integer>> COMPARATOR = new Comparator<Map.Entry<Double, Integer>>(){

        @Override
        public int compare(Map.Entry<Double, Integer> left, Map.Entry<Double, Integer> right) {
            return left.getValue().compareTo(right.getValue());
        }
    };

    public VectorIndexerModelConverter(VectorIndexerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        VectorIndexerModel transformer = (VectorIndexerModel)this.getTransformer();
        int numFeatures = transformer.numFeatures();
        List<Feature> features = encoder.getFeatures(transformer.getInputCol());
        SchemaUtil.checkSize((int)numFeatures, features);
        Map categoryMaps = transformer.javaCategoryMaps();
        ArrayList<Feature> result = new ArrayList<Feature>();
        int length = numFeatures;
        for (int i = 0; i < length; ++i) {
            Feature feature = features.get(i);
            Map categoryMap = (Map)categoryMaps.get(i);
            if (categoryMap != null) {
                ArrayList<Double> categories = new ArrayList<Double>();
                ArrayList<Integer> values = new ArrayList<Integer>();
                ArrayList entries = new ArrayList(categoryMap.entrySet());
                Collections.sort(entries, COMPARATOR);
                for (Map.Entry entry : entries) {
                    Double category = (Double)entry.getKey();
                    Integer value = (Integer)entry.getValue();
                    categories.add(category);
                    values.add(value);
                }
                encoder.toCategorical(feature.getName(), categories);
                MapValues mapValues = ExpressionUtil.createMapValues((String)feature.getName(), categories, values).setDataType(DataType.INTEGER);
                DerivedField derivedField = encoder.createDerivedField(VectorIndexerModelConverter.formatName(transformer, i, length), OpType.CATEGORICAL, DataType.INTEGER, (Expression)mapValues);
                result.add((Feature)new CategoricalFeature((PMMLEncoder)encoder, (Field)derivedField, values));
                continue;
            }
            result.add((Feature)((ContinuousFeature)feature));
        }
        return result;
    }
}

