/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.dmg.pmml.OutputField;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.ClassificationModelConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public abstract class ProbabilisticClassificationModelConverter<T extends ClassificationModel<Vector, T>>
extends ClassificationModelConverter<T> {
    public ProbabilisticClassificationModelConverter(T model) {
        super(model);
    }

    @Override
    public List<OutputField> registerOutputFields(Label label, Model pmmlModel, SparkMLEncoder encoder) {
        ClassificationModel model = (ClassificationModel)this.getModel();
        List<OutputField> result = super.registerOutputFields(label, pmmlModel, encoder);
        CategoricalLabel categoricalLabel = (CategoricalLabel)label;
        String probabilityCol = ((HasProbabilityCol)model).getProbabilityCol();
        result = new ArrayList<OutputField>(result);
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < categoricalLabel.size(); ++i) {
            Object value = categoricalLabel.getValue(i);
            OutputField probabilityField = ModelUtil.createProbabilityField((String)FieldNameUtil.create((String)probabilityCol, (Object[])new Object[]{value}), (DataType)DataType.DOUBLE, (Object)value);
            result.add(probabilityField);
            features.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)probabilityField));
        }
        encoder.putFeatures(probabilityCol, features);
        return result;
    }
}

