/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import com.google.common.io.ByteStreams;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;

public class ArchiveUtil {
    private ArchiveUtil() {
    }

    public static <E extends PipelineStage> E loadZip(MLReader<E> mlReader, File file) throws IOException {
        File tmpDir = ArchiveUtil.uncompress(file);
        PipelineStage stage = (PipelineStage)mlReader.load(tmpDir.getAbsolutePath());
        MoreFiles.deleteRecursively((Path)tmpDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        return (E)stage;
    }

    public static <E extends PipelineStage> void storeZip(E stage, File file) throws IOException {
        ArchiveUtil.storeZip(((MLWritable)stage).write(), file);
    }

    public static void storeZip(MLWriter mlWriter, File file) throws IOException {
        File tmpDir = File.createTempFile("PipelineStage", "");
        if (!tmpDir.delete()) {
            throw new IOException();
        }
        mlWriter.save(tmpDir.getAbsolutePath());
        ArchiveUtil.compress(tmpDir, file);
        MoreFiles.deleteRecursively((Path)tmpDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    public static void compress(File dir, File file) throws IOException {
        final Path dirPath = Paths.get(dir.getAbsolutePath(), new String[0]);
        try (FileOutputStream os = new FileOutputStream(file);){
            final ZipOutputStream zos = new ZipOutputStream(os);
            SimpleFileVisitor<Path> dirFileVisitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes mainAtts) throws IOException {
                    File dirFile = path.toFile();
                    Path relativePath = dirPath.relativize(path);
                    ZipEntry entry = new ZipEntry(relativePath.toString());
                    entry.setSize(dirFile.length());
                    entry.setTime(dirFile.lastModified());
                    zos.putNextEntry(entry);
                    try (FileInputStream is = new FileInputStream(dirFile);){
                        ByteStreams.copy((InputStream)is, (OutputStream)zos);
                    }
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            };
            Files.walkFileTree(dirPath, (FileVisitor<? super Path>)dirFileVisitor);
            zos.finish();
        }
    }

    public static File uncompress(File file) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            File tmpDir = File.createTempFile("PipelineModel", "");
            if (!tmpDir.delete()) {
                throw new IOException();
            }
            tmpDir.mkdirs();
            ArchiveUtil.uncompress(zipFile, tmpDir);
            File file2 = tmpDir;
            return file2;
        }
    }

    public static void uncompress(File file, File dir) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            ArchiveUtil.uncompress(zipFile, dir);
        }
    }

    public static void uncompress(ZipFile zipFile, File dir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            InputStream is = zipFile.getInputStream(entry);
            try {
                File file = new File(dir, entry.getName());
                if (!ArchiveUtil.checkInside(dir, file)) {
                    throw new IOException(file.getAbsolutePath() + " is not inside " + dir.getAbsolutePath());
                }
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdirs()) {
                    throw new IOException(parentDir.getAbsolutePath());
                }
                try (FileOutputStream os = new FileOutputStream(file);){
                    ByteStreams.copy((InputStream)is, (OutputStream)os);
                }
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private static boolean checkInside(File dir, File file) {
        Path dirPath = ArchiveUtil.toCanonicalPath(dir);
        Path filePath = ArchiveUtil.toCanonicalPath(file);
        return filePath.startsWith(dirPath);
    }

    private static Path toCanonicalPath(File file) {
        return file.toPath().normalize().toAbsolutePath();
    }
}

