/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.Bucketizer;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.Interval;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.IndexFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.MultiFeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class BucketizerConverter
extends MultiFeatureConverter<Bucketizer> {
    public BucketizerConverter(Bucketizer transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        Object splitsArray;
        String[] inputCols;
        Bucketizer transformer = (Bucketizer)this.getTransformer();
        FeatureConverter.InOutMode inputMode = this.getInputMode();
        if (inputMode == FeatureConverter.InOutMode.SINGLE) {
            inputCols = inputMode.getInputCols(transformer);
            splitsArray = new double[][]{transformer.getSplits()};
        } else if (inputMode == FeatureConverter.InOutMode.MULTIPLE) {
            inputCols = inputMode.getInputCols(transformer);
            splitsArray = transformer.getSplitsArray();
        } else {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < inputCols.length; ++i) {
            String inputCol = inputCols[i];
            double[] splits = splitsArray[i];
            Feature feature = encoder.getOnlyFeature(inputCol);
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            Discretize discretize = new Discretize(continuousFeature.getName()).setDataType(DataType.INTEGER);
            ArrayList<Integer> categories = new ArrayList<Integer>();
            for (int j = 0; j < splits.length - 1; ++j) {
                Integer category = j;
                categories.add(category);
                Interval.Closure closure = j < splits.length - 2 ? Interval.Closure.CLOSED_OPEN : Interval.Closure.CLOSED_CLOSED;
                Double leftMargin = BucketizerConverter.formatMargin(splits[j]);
                Double rightMargin = BucketizerConverter.formatMargin(splits[j + 1]);
                Interval interval = new Interval(closure, (Number)leftMargin, (Number)rightMargin);
                DiscretizeBin discretizeBin = new DiscretizeBin((Object)category, interval);
                discretize.addDiscretizeBins(new DiscretizeBin[]{discretizeBin});
            }
            DerivedField derivedField = encoder.createDerivedField(BucketizerConverter.formatName(transformer, i), OpType.CATEGORICAL, DataType.INTEGER, (Expression)discretize);
            result.add((Feature)new IndexFeature((PMMLEncoder)encoder, (Field)derivedField, categories));
        }
        return result;
    }

    private static Double formatMargin(double value) {
        if (Double.isInfinite(value)) {
            return null;
        }
        return value;
    }
}

