/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.statsmodels.example;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.model.metro.MetroJAXBSerializer;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.JoblibUnpickler;
import org.jpmml.python.Storage;
import org.jpmml.python.StorageUtil;
import org.jpmml.statsmodels.StatsModelsEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import statsmodels.ResultsWrapper;

public class Main {
    @Parameter(names={"--pkl-input"}, description="Pickle input file", required=true, order=1)
    private File input = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true, order=2)
    private File output = null;
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true, order=0x7FFFFFFF)
    private boolean help = false;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        DefaultUsageFormatter usageFormatter = new DefaultUsageFormatter(commander);
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            usageFormatter.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            usageFormatter.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    public void run() throws Exception {
        PMML pmml;
        long end;
        Object object;
        long begin;
        StatsModelsEncoder encoder = new StatsModelsEncoder();
        try (Storage storage = StorageUtil.createStorage((File)this.input);){
            logger.info("Parsing PKL..");
            JoblibUnpickler pythonUnpickler = new JoblibUnpickler();
            begin = System.currentTimeMillis();
            object = pythonUnpickler.load(storage);
            end = System.currentTimeMillis();
            logger.info("Parsed PKL in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to parse PKL", (Throwable)e);
            throw e;
        }
        if (!(object instanceof ResultsWrapper)) {
            throw new IllegalArgumentException("The object (" + ClassDictUtil.formatClass((Object)object) + ") is not a ResultsWrapper");
        }
        ResultsWrapper resultsWrapper = (ResultsWrapper)object;
        try {
            logger.info("Converting..");
            begin = System.currentTimeMillis();
            pmml = resultsWrapper.encodePMML(encoder);
            end = System.currentTimeMillis();
            logger.info("Converted in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to convert", (Throwable)e);
            throw e;
        }
        try (FileOutputStream os = new FileOutputStream(this.output);){
            logger.info("Marshalling PMML..");
            MetroJAXBSerializer jaxbSerializer = new MetroJAXBSerializer();
            long begin2 = System.currentTimeMillis();
            jaxbSerializer.serializePretty((PMMLObject)pmml, (OutputStream)os);
            long end2 = System.currentTimeMillis();
            logger.info("Marshalled PMML in {} ms.", (Object)(end2 - begin2));
        }
        catch (Exception e) {
            logger.error("Failed to marshal PMML", (Throwable)e);
            throw e;
        }
    }
}

