/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JArray;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import java.util.List;
import java.util.Objects;

public abstract class ArrayManager<E> {
    private JType componentType = null;
    private String name = null;
    private JFieldVar arrayVar = null;
    private JArray array = null;

    public ArrayManager(JType componentType, String name) {
        this.setComponentType(componentType);
        this.setName(name);
    }

    public abstract List<E> getElements();

    public int size() {
        List<E> elements = this.getElements();
        return elements.size();
    }

    public void initArrayVar(JDefinedClass owner) {
        JType componentType = this.getComponentType();
        String name = this.getName();
        this.arrayVar = owner.field(28, (JType)componentType.array(), name);
    }

    public void initArray() {
        JType componentType = this.getComponentType();
        if (this.arrayVar == null) {
            throw new IllegalStateException();
        }
        JArray array = JExpr.newArray((JType)componentType);
        this.arrayVar.init((JExpression)array);
        this.array = array;
    }

    public JType getComponentType() {
        return this.componentType;
    }

    private void setComponentType(JType componentType) {
        this.componentType = Objects.requireNonNull(componentType);
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public JFieldVar getArrayVar() {
        return this.arrayVar;
    }

    public JArray getArray() {
        return this.array;
    }
}

