/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.google.common.collect.Iterables;
import com.sun.codemodel.JArray;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.codemodel.fmt.JBinaryFile;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.dmg.pmml.MathContext;
import org.jpmml.evaluator.ResourceUtil;
import org.jpmml.evaluator.TokenizedString;
import org.jpmml.translator.JClassInitializer;
import org.jpmml.translator.TranslationContext;

public class JBinaryFileInitializer
extends JClassInitializer {
    private JBinaryFile binaryFile = null;
    private JVar dataInputVar = null;
    private JBlock tryBody = new JBlock();
    private JVar ioeVar = null;
    private JBlock catchBody = new JBlock();

    public JBinaryFileInitializer(String name, TranslationContext context) {
        this(name, -1, context);
    }

    public JBinaryFileInitializer(String name, int pos, TranslationContext context) {
        super(context);
        JBinaryFile binaryFile = new JBinaryFile(name);
        this.setBinaryFile(binaryFile);
        JDefinedClass owner = context.getOwner();
        JPackage _package = owner.getPackage();
        _package.addResourceFile((JResourceFile)binaryFile);
        JBlock resourceStmt = new JBlock(false, false);
        JClass dataInputStreamClazz = context.ref(DataInputStream.class);
        JInvocation isExpr = JExpr.dotclass((JClass)owner).invoke("getResourceAsStream").arg(name);
        this.dataInputVar = resourceStmt.decl((JType)dataInputStreamClazz, "dataInput", (JExpression)context._new(dataInputStreamClazz, isExpr));
        JBlock catchStmt = new JBlock(false, false);
        this.ioeVar = catchStmt.decl((JType)context.ref(IOException.class), "ioe");
        this.catchBody._throw((JExpression)context._new(ExceptionInInitializerError.class, this.ioeVar));
        JStatement tryWithResources = new JStatement(){

            public void state(JFormatter formatter) {
                formatter.p("try(").b(JBinaryFileInitializer.this.dataInputVar).p(")");
                formatter.g((JGenerable)JBinaryFileInitializer.this.tryBody);
                formatter.p("catch(").b(JBinaryFileInitializer.this.ioeVar).p(")");
                formatter.g((JGenerable)JBinaryFileInitializer.this.catchBody);
                formatter.nl();
            }
        };
        JBlock init = owner.init();
        if (pos > -1) {
            init.pos(pos);
        }
        init.add(tryWithResources);
    }

    @Override
    public void add(JStatement statement) {
        this.tryBody.add(statement);
    }

    public void initQNames(JFieldVar field, QName[] names) {
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            ResourceUtil.writeQNames((DataOutput)dataOutput, (QName[])names);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JInvocation invocation = context.staticInvoke(ResourceUtil.class, "readQNames", this.dataInputVar, names.length);
        this.tryBody.assign((JAssignmentTarget)field, (JExpression)invocation);
    }

    /*
     * Unable to fully structure code
     */
    public void initValues(JFieldVar field, Object[] values) {
        context = this.getContext();
        binaryFile = this.getBinaryFile();
        try {
            os = binaryFile.getDataStore();
            var7_7 = null;
            try {
                dataOutput = new DataOutputStream(os);
                arrayType = (JClass)field.type();
                arrayElementType = (JClass)arrayType.elementType();
                var12_14 = typeName = arrayElementType.fullName();
                var13_15 = -1;
                switch (var12_14.hashCode()) {
                    case 1195259493: {
                        if (!var12_14.equals("java.lang.String")) break;
                        var13_15 = 0;
                        break;
                    }
                    case -2056817302: {
                        if (!var12_14.equals("java.lang.Integer")) break;
                        var13_15 = 1;
                        break;
                    }
                    case 761287205: {
                        if (!var12_14.equals("java.lang.Double")) break;
                        var13_15 = 2;
                        break;
                    }
                    case -527879800: {
                        if (!var12_14.equals("java.lang.Float")) break;
                        var13_15 = 3;
                    }
                }
                switch (var13_15) {
                    case 0: {
                        ResourceUtil.writeStrings((DataOutput)dataOutput, (String[])JBinaryFileInitializer.castArray(values, new String[values.length]));
                        readMethod = "readStrings";
                        ** break;
lbl33:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        ResourceUtil.writeIntegers((DataOutput)dataOutput, (Number[])JBinaryFileInitializer.castArray(values, new Integer[values.length]));
                        readMethod = "readIntegers";
                        ** break;
lbl38:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        ResourceUtil.writeDoubles((DataOutput)dataOutput, (Number[])JBinaryFileInitializer.castArray(values, new Double[values.length]));
                        readMethod = "readDoubles";
                        ** break;
lbl43:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        ResourceUtil.writeFloats((DataOutput)dataOutput, (Number[])JBinaryFileInitializer.castArray(values, new Float[values.length]));
                        readMethod = "readFloats";
                        ** break;
lbl48:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(typeName);
                    }
                }
            }
            catch (Throwable var8_10) {
                var7_7 = var8_10;
                throw var8_10;
            }
            finally {
                if (os != null) {
                    if (var7_7 != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable var8_9) {
                            var7_7.addSuppressed(var8_9);
                        }
                    } else {
                        os.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        invocation = context.staticInvoke(ResourceUtil.class, readMethod, new Object[]{this.dataInputVar, values.length});
        this.tryBody.assign((JAssignmentTarget)field, (JExpression)invocation);
    }

    public JFieldVar initTokenizedStringLists(String name, TokenizedString[] tokenizedStrings) {
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        JFieldVar constant = JBinaryFileInitializer.createListConstant(name, context.ref(TokenizedString.class), context);
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            ResourceUtil.writeTokenizedStrings((DataOutput)dataOutput, (TokenizedString[])tokenizedStrings);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JInvocation invocation = context.staticInvoke(ResourceUtil.class, "readTokenizedStrings", this.dataInputVar, tokenizedStrings.length);
        this.add((JStatement)context.staticInvoke(Collections.class, "addAll", constant, invocation));
        return constant;
    }

    /*
     * Unable to fully structure code
     */
    public JFieldVar initNumbers(String name, MathContext mathContext, Number[] values) {
        context = this.getContext();
        binaryFile = this.getBinaryFile();
        constant = JBinaryFileInitializer.createListConstant(name, context.ref(Number.class), context);
        try {
            os = binaryFile.getDataStore();
            var8_9 = null;
            try {
                dataOutput = new DataOutputStream(os);
                switch (2.$SwitchMap$org$dmg$pmml$MathContext[mathContext.ordinal()]) {
                    case 1: {
                        ResourceUtil.writeFloats((DataOutput)dataOutput, (Number[])values);
                        ** break;
lbl13:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        ResourceUtil.writeDoubles((DataOutput)dataOutput, (Number[])values);
                        ** break;
lbl17:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            catch (Throwable var9_12) {
                var8_9 = var9_12;
                throw var9_12;
            }
            finally {
                if (os != null) {
                    if (var8_9 != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable var9_11) {
                            var8_9.addSuppressed(var9_11);
                        }
                    } else {
                        os.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        invocation = context.staticInvoke(ResourceUtil.class, JBinaryFileInitializer.readNumbers(mathContext), new Object[]{this.dataInputVar, values.length});
        this.add((JStatement)context.staticInvoke(Collections.class, "addAll", new Object[]{constant, invocation}));
        return constant;
    }

    public JFieldVar initNumbersList(String name, MathContext mathContext, List<Number[]> elements) {
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        JFieldVar constant = JBinaryFileInitializer.createListConstant(name, context.ref(Number[].class), context);
        JType intType = context._ref(Integer.TYPE);
        JArray countArray = JExpr.newArray((JType)intType);
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            for (Number[] element : elements) {
                switch (mathContext) {
                    case FLOAT: {
                        ResourceUtil.writeFloats((DataOutput)dataOutput, (Number[])element);
                        break;
                    }
                    case DOUBLE: {
                        ResourceUtil.writeDoubles((DataOutput)dataOutput, (Number[])element);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                countArray.add(JExpr.lit((int)element.length));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JMethod initMethod = JBinaryFileInitializer.createMethod(name, context)._throws(IOException.class);
        JVar dataInputParam = initMethod.param(DataInputStream.class, "dataInput");
        JBlock block = initMethod.body();
        JVar countsVar = block.decl((JType)intType.array(), "counts", (JExpression)countArray);
        JForEach forEach = block.forEach(intType, "count", (JExpression)countsVar);
        JInvocation invocation = context.staticInvoke(ResourceUtil.class, JBinaryFileInitializer.readNumbers(mathContext), dataInputParam, forEach.var());
        forEach.body().add((JStatement)constant.invoke("add").arg((JExpression)invocation));
        this.add((JStatement)JExpr.invoke((JMethod)initMethod).arg((JExpression)this.dataInputVar));
        return constant;
    }

    public JFieldVar initNumberArraysList(String name, MathContext mathContext, List<Number[][]> elements, int length) {
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        JFieldVar constant = JBinaryFileInitializer.createListConstant(name, context.ref(Number[][].class), context);
        JType intType = context._ref(Integer.TYPE);
        JArray countArray = JExpr.newArray((JType)intType);
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            for (Number[][] element : elements) {
                switch (mathContext) {
                    case FLOAT: {
                        ResourceUtil.writeFloatArrays((DataOutput)dataOutput, (Number[][])element);
                        break;
                    }
                    case DOUBLE: {
                        ResourceUtil.writeDoubleArrays((DataOutput)dataOutput, (Number[][])element);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                countArray.add(JExpr.lit((int)element.length));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JMethod initMethod = JBinaryFileInitializer.createMethod(name, context)._throws(IOException.class);
        JVar dataInputParam = initMethod.param(DataInputStream.class, "dataInput");
        JBlock block = initMethod.body();
        JVar countsVar = block.decl((JType)intType.array(), "counts", (JExpression)countArray);
        JForEach forEach = block.forEach(intType, "count", (JExpression)countsVar);
        JInvocation invocation = context.staticInvoke(ResourceUtil.class, JBinaryFileInitializer.readNumberArrays(mathContext), dataInputParam, forEach.var(), length);
        forEach.body().add((JStatement)constant.invoke("add").arg((JExpression)invocation));
        this.add((JStatement)JExpr.invoke((JMethod)initMethod).arg((JExpression)this.dataInputVar));
        return constant;
    }

    public JFieldVar initNumbersMap(String name, Map<?, Number> map) {
        String valueReadMethod;
        String keyReadMethod;
        JFieldVar constant;
        JDefinedClass owner;
        TranslationContext context;
        block23: {
            context = this.getContext();
            JBinaryFile binaryFile = this.getBinaryFile();
            owner = context.getOwner();
            constant = JBinaryFileInitializer.createMapConstant(name, context.ref(Object.class), context.ref(Number.class), context);
            try (OutputStream os = binaryFile.getDataStore();){
                DataOutputStream dataOutput = new DataOutputStream(os);
                Set<?> keys = map.keySet();
                Class<?> keyClazz = JBinaryFileInitializer.getValueClass(keys);
                if (Objects.equals(keyClazz, String.class)) {
                    ResourceUtil.writeStrings((DataOutput)dataOutput, (String[])keys.toArray(new String[keys.size()]));
                    keyReadMethod = "readStrings";
                } else if (Objects.equals(keyClazz, Float.class)) {
                    ResourceUtil.writeFloats((DataOutput)dataOutput, (Number[])keys.toArray(new Float[keys.size()]));
                    keyReadMethod = "readFloats";
                } else if (Objects.equals(keyClazz, Double.class)) {
                    ResourceUtil.writeDoubles((DataOutput)dataOutput, (Number[])keys.toArray(new Double[keys.size()]));
                    keyReadMethod = "readDoubles";
                } else {
                    throw new IllegalArgumentException();
                }
                Collection<Number> values = map.values();
                Class<?> valueClazz = JBinaryFileInitializer.getValueClass(values);
                if (Objects.equals(valueClazz, Float.class)) {
                    ResourceUtil.writeFloats((DataOutput)dataOutput, (Number[])values.toArray(new Float[values.size()]));
                    valueReadMethod = "readFloats";
                    break block23;
                }
                if (Objects.equals(valueClazz, Double.class)) {
                    ResourceUtil.writeDoubles((DataOutput)dataOutput, (Number[])values.toArray(new Double[values.size()]));
                    valueReadMethod = "readDoubles";
                    break block23;
                }
                throw new IllegalArgumentException();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        JClass objectArrayClass = context.ref(Object[].class);
        JClass numberArrayClass = context.ref(Number[].class);
        JMethod putAllMethod = owner.getMethod("putAll", new JType[]{constant.type(), objectArrayClass, numberArrayClass});
        if (putAllMethod == null) {
            putAllMethod = owner.method(28, Void.TYPE, "putAll");
            JVar mapParam = putAllMethod.param(constant.type(), "map");
            JVar keysParam = putAllMethod.param((JType)objectArrayClass, "keys");
            JVar valuesParam = putAllMethod.param((JType)numberArrayClass, "values");
            JBlock block = putAllMethod.body();
            JForLoop forLoop = block._for();
            JVar loopVar = forLoop.init(context._ref(Integer.TYPE), "i", JExpr.lit((int)0));
            forLoop.test(loopVar.lt((JExpression)keysParam.ref("length")));
            forLoop.update(loopVar.incr());
            JBlock forBlock = forLoop.body();
            forBlock.add((JStatement)JExpr.invoke((JExpression)mapParam, (String)"put").arg((JExpression)keysParam.component((JExpression)loopVar)).arg((JExpression)valuesParam.component((JExpression)loopVar)));
        }
        JInvocation keysInvocation = context.staticInvoke(ResourceUtil.class, keyReadMethod, this.dataInputVar, map.size());
        JInvocation valuesInvocation = context.staticInvoke(ResourceUtil.class, valueReadMethod, this.dataInputVar, map.size());
        this.add((JStatement)JExpr.invoke((JMethod)putAllMethod).arg((JExpression)constant).arg((JExpression)keysInvocation).arg((JExpression)valuesInvocation));
        return constant;
    }

    public JBinaryFile getBinaryFile() {
        return this.binaryFile;
    }

    private void setBinaryFile(JBinaryFile binaryFile) {
        this.binaryFile = binaryFile;
    }

    private static <E> E[] castArray(Object[] values, E[] newValues) {
        return Arrays.asList(values).toArray(newValues);
    }

    public static boolean isExternalizable(Class<?> clazz) {
        if (Objects.equals(clazz, String.class)) {
            return true;
        }
        return Objects.equals(clazz, Integer.class) || Objects.equals(clazz, Float.class) || Objects.equals(clazz, Double.class);
    }

    public static boolean isExternalizable(Collection<?> values) {
        Class<?> valueClazz = JBinaryFileInitializer.getValueClass(values);
        return JBinaryFileInitializer.isExternalizable(valueClazz);
    }

    public static Class<?> getValueClass(Collection<?> values) {
        Set valueClazzes = values.stream().map(value -> value.getClass()).collect(Collectors.toSet());
        if (valueClazzes.size() == 1) {
            return (Class)Iterables.getOnlyElement(valueClazzes);
        }
        return Object.class;
    }

    private static String readNumbers(MathContext mathContext) {
        switch (mathContext) {
            case FLOAT: {
                return "readFloats";
            }
            case DOUBLE: {
                return "readDoubles";
            }
        }
        throw new IllegalArgumentException();
    }

    private static String readNumberArrays(MathContext mathContext) {
        switch (mathContext) {
            case FLOAT: {
                return "readFloatArrays";
            }
            case DOUBLE: {
                return "readDoubleArrays";
            }
        }
        throw new IllegalArgumentException();
    }
}

