/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jpmml.translator.OperableRef;
import org.jpmml.translator.OrdinalEncoder;
import org.jpmml.translator.TranslationContext;

public class OrdinalRef
extends OperableRef {
    private OrdinalEncoder encoder = null;

    public OrdinalRef(JExpression expression, OrdinalEncoder encoder) {
        super(expression);
        this.setEncoder(encoder);
    }

    @Override
    public boolean requiresNotMissingCheck() {
        return false;
    }

    @Override
    public JExpression isMissing() {
        JExpression expression = this.getExpression();
        return expression.eq(OrdinalEncoder.MISSING_VALUE);
    }

    @Override
    public JExpression isNotMissing() {
        JExpression expression = this.getExpression();
        return expression.ne(OrdinalEncoder.MISSING_VALUE);
    }

    @Override
    public JExpression equalTo(Object value, TranslationContext context) {
        JExpression expression = this.getExpression();
        OrdinalEncoder encoder = this.getEncoder();
        value = encoder.encode(value);
        return expression.eq(this.literal(value, context));
    }

    @Override
    public JExpression notEqualTo(Object value, TranslationContext context) {
        JExpression expression = this.getExpression();
        OrdinalEncoder encoder = this.getEncoder();
        value = encoder.encode(value);
        return expression.ne(OrdinalEncoder.MISSING_VALUE).cand(expression.ne(this.literal(value, context)));
    }

    @Override
    public JExpression isIn(Collection<?> values, TranslationContext context) {
        JExpression expression = this.getExpression();
        OrdinalEncoder encoder = this.getEncoder();
        List<Chunk> chunks = OrdinalRef.chunk(encoder, values);
        OrdinalRef.ensureIsSetMethod(encoder, chunks, context);
        Iterator<Chunk> it = chunks.iterator();
        JExpression result = it.next().isIn(expression);
        while (it.hasNext()) {
            result = result.cor(it.next().isIn(expression));
        }
        return result;
    }

    @Override
    public JExpression isNotIn(Collection<?> values, TranslationContext context) {
        JExpression expression = this.getExpression();
        OrdinalEncoder encoder = this.getEncoder();
        List<Chunk> chunks = OrdinalRef.chunk(encoder, values);
        OrdinalRef.ensureIsSetMethod(encoder, chunks, context);
        Iterator<Chunk> it = chunks.iterator();
        JExpression result = expression.ne(OrdinalEncoder.MISSING_VALUE).cand(it.next().isNotIn(expression));
        while (it.hasNext()) {
            result = result.cand(it.next().isNotIn(expression));
        }
        return result;
    }

    public OrdinalEncoder getEncoder() {
        return this.encoder;
    }

    private void setEncoder(OrdinalEncoder encoder) {
        this.encoder = encoder;
    }

    public static List<Chunk> chunk(OrdinalEncoder encoder, Collection<?> values) {
        ArrayList<Chunk> result = new ArrayList<Chunk>();
        Iterator it = values.stream().map(encoder::encode).distinct().sorted().iterator();
        ArrayList chunk = null;
        while (it.hasNext()) {
            Integer value = (Integer)it.next();
            if (chunk == null) {
                chunk = new Chunk();
                chunk.add(value);
                continue;
            }
            Integer offsetValue = (Integer)chunk.get(0);
            if (value - offsetValue < 32) {
                chunk.add(value);
                continue;
            }
            result.add((Chunk)chunk);
            chunk = new Chunk();
            chunk.add(value);
        }
        if (chunk != null) {
            result.add((Chunk)chunk);
        }
        return result;
    }

    private static void ensureIsSetMethod(OrdinalEncoder encoder, Collection<Chunk> chunks, TranslationContext context) {
        for (Chunk chunk : chunks) {
            if (chunk.size() <= 2 || chunk.isDense()) continue;
            encoder.ensureIsSetMethod(context);
            return;
        }
    }

    public static class Chunk
    extends ArrayList<Integer> {
        public boolean isDense() {
            int size = this.size();
            if (size == 1) {
                return true;
            }
            if (size > 1) {
                int firstValue = (Integer)this.get(0);
                int lastValue = (Integer)this.get(size - 1);
                return lastValue - firstValue == size - 1;
            }
            throw new IllegalStateException();
        }

        public JExpression isIn(JExpression expression) {
            int size = this.size();
            if (size == 1) {
                return expression.eq(this.literal(0));
            }
            if (size == 2) {
                return expression.eq(this.literal(0)).cor(expression.eq(this.literal(1)));
            }
            if (this.isDense()) {
                return expression.gte(this.literal(0)).cand(expression.lte(this.literal(size - 1)));
            }
            return this.isSet(expression);
        }

        public JExpression isNotIn(JExpression expression) {
            int size = this.size();
            if (size == 1) {
                return expression.ne(this.literal(0));
            }
            if (size == 2) {
                return expression.ne(this.literal(0)).cand(expression.ne(this.literal(1)));
            }
            if (this.isDense()) {
                return expression.lt(this.literal(0)).cor(expression.gt(this.literal(size - 1)));
            }
            return this.isSet(expression).not();
        }

        public JExpression isSet(JExpression expression) {
            int size = this.size();
            int firstValue = (Integer)this.get(0);
            int lastValue = (Integer)this.get(size - 1);
            Chunk values = this;
            int bitSet = 0;
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                if (firstValue >= 1 && lastValue <= 32) {
                    bitSet |= 1 << value - 1;
                    continue;
                }
                bitSet |= 1 << value - firstValue;
            }
            JExpression bitSetExpr = JExpr.lit((int)bitSet);
            JExpression indexExpr = firstValue >= 1 && lastValue <= 32 ? expression.minus(JExpr.lit((int)1)) : expression.minus(JExpr.lit((int)firstValue));
            return JExpr.invoke((String)"isSet").arg(bitSetExpr).arg(indexExpr);
        }

        private JExpression literal(int index) {
            return JExpr.lit((int)((Integer)this.get(index)));
        }
    }
}

