/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.sun.codemodel.JArray;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import jakarta.xml.bind.JAXBElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.dmg.pmml.ComplexArray;
import org.dmg.pmml.ComplexValue;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.False;
import org.dmg.pmml.HasDiscreteDomain;
import org.dmg.pmml.Header;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.True;
import org.dmg.pmml.Value;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.evaluator.java.JavaModel;
import org.jpmml.model.PMMLException;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.translator.ExpressionTranslator;
import org.jpmml.translator.ExpressionTranslatorFactory;
import org.jpmml.translator.IdentifierUtil;
import org.jpmml.translator.JBinaryFileInitializer;
import org.jpmml.translator.JExpressionRef;
import org.jpmml.translator.JVarBuilder;
import org.jpmml.translator.JavaModelTemplate;
import org.jpmml.translator.MethodScope;
import org.jpmml.translator.ModelTranslator;
import org.jpmml.translator.ModelTranslatorFactory;
import org.jpmml.translator.Template;
import org.jpmml.translator.TranslationContext;
import org.w3c.dom.Element;

public class PMMLObjectUtil {
    private static final int CHUNK_SIZE = 256;

    private PMMLObjectUtil() {
    }

    public static JDefinedClass createClass(PMMLObject object, String className, TranslationContext context) {
        JDefinedClass definedClazz;
        JCodeModel codeModel = context.getCodeModel();
        Class<?> clazz = object.getClass();
        try {
            definedClazz = codeModel._class(className != null ? className : IdentifierUtil.create(clazz.getSimpleName(), object));
        }
        catch (JClassAlreadyExistsException jcaee) {
            throw new IllegalArgumentException(jcaee);
        }
        definedClazz._extends(clazz);
        JMethod loaderMethod = definedClazz.method(28, Void.TYPE, "ensureLoaded");
        JBlock init = definedClazz.init();
        init.add((JStatement)definedClazz.staticInvoke(loaderMethod));
        return definedClazz;
    }

    public static JDefinedClass createMemberClass(int mods, String name, TranslationContext context) {
        JDefinedClass definedClazz;
        JDefinedClass owner = context.getOwner();
        try {
            definedClazz = owner._class(mods, name);
        }
        catch (JClassAlreadyExistsException jcaee) {
            throw new IllegalArgumentException(jcaee);
        }
        JMethod loaderMethod = definedClazz.method(28, Void.TYPE, "ensureLoaded");
        JMethod ownerLoaderMethod = owner.getMethod("ensureLoaded", new JType[0]);
        JBlock block = ownerLoaderMethod.body();
        block.add((JStatement)definedClazz.staticInvoke(loaderMethod));
        return definedClazz;
    }

    public static JMethod createDefaultConstructor(PMMLObject object, TranslationContext context) {
        JDefinedClass owner = context.getOwner();
        JMethod constructor = owner.constructor(1);
        JBlock block = constructor.body();
        block.add((JStatement)PMMLObjectUtil.constructObject(object, JExpr.invoke((String)"super"), context));
        block.add((JStatement)PMMLObjectUtil.initializeObject(object, null, context));
        return constructor;
    }

    public static JMethod createBuilderMethod(PMMLObject object, TranslationContext context) {
        JDefinedClass owner;
        String simpleName;
        Class<?> clazz;
        for (clazz = object.getClass(); clazz != null && (simpleName = clazz.getSimpleName()).startsWith("Rich"); clazz = clazz.getSuperclass()) {
        }
        JMethod method = owner.method((owner = context.getOwner()).isAnonymous() ? 12 : 28, clazz, IdentifierUtil.create("build" + clazz.getSimpleName(), object));
        JBlock block = method.body();
        block._return((JExpression)PMMLObjectUtil.createObject(object, context));
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JMethod createArrayBuilderMethod(Class<?> clazz, List<?> objects, TranslationContext context) {
        JDefinedClass owner;
        JMethod method = owner.method((owner = context.getOwner()).isAnonymous() ? 12 : 28, (JType)context.ref(clazz).array(), IdentifierUtil.create("build" + clazz.getSimpleName() + "Array", objects));
        JBlock block = method.body();
        JVar resultVar = block.decl((JType)context.ref(List.class).narrow(clazz), "result", (JExpression)context._new(ArrayList.class, objects.size()));
        for (int i = 0; i < objects.size(); i += 256) {
            List<?> chunk = objects.subList(i, Math.min(i + 256, objects.size()));
            JMethod chunkMethod = owner.method(method.mods().getValue(), method.type(), method.name() + "$" + i + "_" + (i + chunk.size()));
            try {
                context.pushScope(new MethodScope(chunkMethod));
                JArray array = JExpr.newArray((JType)context.ref(clazz));
                for (Object object : chunk) {
                    array.add(PMMLObjectUtil.createExpression(object, context));
                }
                context._return((JExpression)array);
            }
            finally {
                context.popScope();
            }
            JInvocation invocation = context.staticInvoke(Collections.class, "addAll", resultVar, JExpr.invoke((JMethod)chunkMethod));
            block.add((JStatement)invocation);
        }
        block._return((JExpression)resultVar.invoke("toArray").arg((JExpression)JExpr.newArray((JType)context.ref(clazz), (JExpression)resultVar.invoke("size"))));
        return method;
    }

    public static JInvocation createObject(PMMLObject object, TranslationContext context) {
        Class<?> clazz = object.getClass();
        JInvocation invocation = PMMLObjectUtil.constructObject(object, context._new(clazz, new Object[0]), context);
        invocation = PMMLObjectUtil.initializeObject(object, invocation, context);
        return invocation;
    }

    public static JInvocation constructObject(PMMLObject object, JInvocation invocation, TranslationContext context) {
        Template template = Template.getTemplate(object.getClass());
        return template.constructObject(object, invocation, context);
    }

    public static JInvocation initializeObject(PMMLObject object, JInvocation invocation, TranslationContext context) {
        Template template = Template.getTemplate(object.getClass());
        return template.initializeObject(object, invocation, context);
    }

    public static JInvocation initializeJavaModel(Model model, JInvocation invocation, TranslationContext context) {
        JavaModelTemplate javaModelTemplate = (JavaModelTemplate)Template.getTemplate(JavaModel.class);
        return javaModelTemplate.initializeObject((PMMLObject)model, invocation, context);
    }

    public static JExpression createExpression(Object value, TranslationContext context) {
        if (value instanceof JExpressionRef) {
            JExpressionRef variableRef = (JExpressionRef)value;
            return variableRef.getExpression();
        }
        if (value instanceof JVarBuilder) {
            JVarBuilder variableBuilder = (JVarBuilder)value;
            return variableBuilder.getVariable();
        }
        if (value instanceof JExpression) {
            JExpression expression = (JExpression)value;
            return expression;
        }
        if (value == null) {
            return JExpr._null();
        }
        Class<?> clazz = value.getClass();
        if (ReflectionUtil.isPrimitiveWrapper(clazz)) {
            if (Integer.class.equals(clazz)) {
                return JExpr.lit((int)((Integer)value));
            }
            if (Float.class.equals(clazz)) {
                return JExpr.lit((float)((Float)value).floatValue());
            }
            if (Double.class.equals(clazz)) {
                return JExpr.lit((double)((Double)value));
            }
            if (Boolean.class.equals(clazz)) {
                return JExpr.lit((boolean)((Boolean)value));
            }
        } else {
            if (String.class.isAssignableFrom(clazz)) {
                return JExpr.lit((String)((String)value));
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                Enum enumValue = (Enum)value;
                JClass enumClass = context.ref(clazz);
                return enumClass.staticRef(enumValue.name());
            }
            if (QName.class.isAssignableFrom(clazz)) {
                QName xmlName = (QName)value;
                return context.constantXmlName(xmlName);
            }
            if (ComplexValue.class.isAssignableFrom(clazz)) {
                if (value instanceof ComplexArray.ListValue) {
                    List elements = (List)value;
                    JInvocation invocation = context.staticInvoke(Arrays.class, "asList", new Object[0]);
                    PMMLObjectUtil.initializeArray(Object.class, elements, invocation, context);
                    return invocation;
                }
                if (value instanceof ComplexArray.SetValue) {
                    Set elements = (Set)value;
                    JInvocation invocation = context.staticInvoke(Arrays.class, "asList", new Object[0]);
                    PMMLObjectUtil.initializeArray(Object.class, new ArrayList(elements), invocation, context);
                    return context._new(context.ref(LinkedHashSet.class).narrow(context.ref(Object.class).wildcard()), invocation);
                }
            } else {
                if (PMMLObject.class.isAssignableFrom(clazz)) {
                    PMMLObject pmmlObject = (PMMLObject)value;
                    if (True.INSTANCE.equals(pmmlObject)) {
                        JClass trueClass = context.ref(True.class);
                        return trueClass.staticRef("INSTANCE");
                    }
                    if (False.INSTANCE.equals(pmmlObject)) {
                        JClass falseClass = context.ref(False.class);
                        return falseClass.staticRef("INSTANCE");
                    }
                    Class<?> pmmlObjectClazz = pmmlObject.getClass();
                    if (pmmlObjectClazz.isAnonymousClass()) {
                        throw new IllegalArgumentException();
                    }
                    if (pmmlObject instanceof Header || pmmlObject instanceof DataDictionary || pmmlObject instanceof TransformationDictionary) {
                        JMethod builderMethod = PMMLObjectUtil.createBuilderMethod(pmmlObject, context);
                        return JExpr.invoke((JMethod)builderMethod);
                    }
                    if (pmmlObject instanceof MiningSchema || pmmlObject instanceof LocalTransformations || pmmlObject instanceof Output || pmmlObject instanceof ModelStats || pmmlObject instanceof ModelExplanation || pmmlObject instanceof ModelVerification) {
                        JMethod builderMethod = PMMLObjectUtil.createBuilderMethod(pmmlObject, context);
                        return JExpr.invoke((JMethod)builderMethod);
                    }
                    if (pmmlObject instanceof org.dmg.pmml.Field) {
                        ArrayList suppressedPmmlValues;
                        ArrayListMultimap discreteValues;
                        org.dmg.pmml.Field field;
                        block49: {
                            HasDiscreteDomain hasDiscreteDomain;
                            field = (org.dmg.pmml.Field)pmmlObject;
                            discreteValues = ArrayListMultimap.create();
                            suppressedPmmlValues = null;
                            if (field instanceof HasDiscreteDomain && (hasDiscreteDomain = (HasDiscreteDomain)field).hasValues()) {
                                List pmmlValues = hasDiscreteDomain.getValues();
                                for (Value pmmlValue : pmmlValues) {
                                    String displayName = pmmlValue.getDisplayValue();
                                    if (displayName != null || pmmlValue.hasExtensions()) {
                                        discreteValues.clear();
                                        break block49;
                                    }
                                    discreteValues.put((Object)pmmlValue.getProperty(), pmmlValue.requireValue());
                                }
                                suppressedPmmlValues = new ArrayList(pmmlValues);
                                PMMLObjectUtil.ensureEditableValues((org.dmg.pmml.Field)((HasDiscreteDomain)field)).clear();
                            }
                        }
                        JMethod builderMethod = PMMLObjectUtil.createBuilderMethod(pmmlObject, context);
                        if (field instanceof HasDiscreteDomain) {
                            JInvocation invocation;
                            Field returnExprField;
                            JStatement _return;
                            HasDiscreteDomain hasDiscreteDomain = (HasDiscreteDomain)field;
                            if (suppressedPmmlValues != null) {
                                PMMLObjectUtil.ensureEditableValues((org.dmg.pmml.Field)((HasDiscreteDomain)field)).addAll(suppressedPmmlValues);
                            }
                            JBlock body = builderMethod.body();
                            try {
                                Class<?> returnClazz = Class.forName("com.sun.codemodel.JReturn");
                                _return = (JStatement)returnClazz.cast(Iterables.getLast((Iterable)body.getContents()));
                                returnExprField = returnClazz.getDeclaredField("expr");
                                if (!returnExprField.isAccessible()) {
                                    returnExprField.setAccessible(true);
                                }
                                invocation = (JInvocation)returnExprField.get(_return);
                            }
                            catch (ReflectiveOperationException roe) {
                                throw new IllegalArgumentException(roe);
                            }
                            Set entries = discreteValues.asMap().entrySet();
                            for (Map.Entry entry : entries) {
                                Value.Property property = (Value.Property)entry.getKey();
                                List values = (List)entry.getValue();
                                if (values == null || values.isEmpty()) continue;
                                Class<?> valueClazz = JBinaryFileInitializer.getValueClass(values);
                                invocation = invocation.invoke("addValues").arg(PMMLObjectUtil.createExpression(property, context));
                                if (values.size() > 2 && JBinaryFileInitializer.isExternalizable(valueClazz)) {
                                    JFieldRef valuesFieldRef = context.constantValues(valueClazz, IdentifierUtil.create(property.name().toLowerCase(), (PMMLObject)field), values);
                                    invocation = invocation.arg((JExpression)JExpr.cast((JType)context.ref(Object[].class), (JExpression)valuesFieldRef));
                                    continue;
                                }
                                invocation = PMMLObjectUtil.initializeArray(valueClazz, values, invocation, context);
                            }
                            try {
                                returnExprField.set(_return, invocation);
                            }
                            catch (ReflectiveOperationException roe) {
                                throw new IllegalArgumentException(roe);
                            }
                        }
                        return JExpr.invoke((JMethod)builderMethod);
                    }
                    if (pmmlObject instanceof DefineFunction) {
                        JMethod builderMethod = PMMLObjectUtil.createBuilderMethod(pmmlObject, context);
                        return JExpr.invoke((JMethod)builderMethod);
                    }
                    if (pmmlObject instanceof Segmentation || pmmlObject instanceof Segment) {
                        JMethod builderMethod = PMMLObjectUtil.createBuilderMethod(pmmlObject, context);
                        return JExpr.invoke((JMethod)builderMethod);
                    }
                    if (pmmlObject instanceof Model) {
                        PMML pmml = context.getPMML();
                        Model model = (Model)pmmlObject;
                        ModelTranslatorFactory modelTranslatorFactory = ModelTranslatorFactory.getInstance();
                        try {
                            ModelTranslator<?> modelTranslator = modelTranslatorFactory.newModelTranslator(pmml, model);
                            return modelTranslator.translate(context);
                        }
                        catch (PMMLException pe) {
                            context.addIssue(pe);
                            JMethod builderMethod = PMMLObjectUtil.createBuilderMethod(pmmlObject, context);
                            return JExpr.invoke((JMethod)builderMethod);
                        }
                    }
                    if (pmmlObject instanceof Expression) {
                        Expression expression = (Expression)pmmlObject;
                        ExpressionTranslatorFactory expressionTranslatorFactory = ExpressionTranslatorFactory.getInstance();
                        try {
                            ExpressionTranslator<?> expressionTranslator = expressionTranslatorFactory.newExpressionTranslator(expression);
                            return expressionTranslator.translate(context);
                        }
                        catch (PMMLException pe) {
                            context.addIssue(pe);
                            return PMMLObjectUtil.createObject(pmmlObject, context);
                        }
                    }
                    return PMMLObjectUtil.createObject(pmmlObject, context);
                }
                if (JAXBElement.class.isAssignableFrom(clazz)) {
                    JAXBElement jaxbElement = (JAXBElement)value;
                    Object jaxbValue = jaxbElement.getValue();
                    return context._new(context.ref(JAXBElement.class).narrow(jaxbValue.getClass()), jaxbElement.getName(), JExpr.dotclass((JClass)context.ref(jaxbValue.getClass())), jaxbValue);
                }
                if (Element.class.isAssignableFrom(clazz)) {
                    String prefix;
                    String localName;
                    Element domElement = (Element)value;
                    String namespaceURI = domElement.getNamespaceURI();
                    if (namespaceURI == null) {
                        namespaceURI = "";
                    }
                    if ((localName = domElement.getLocalName()) == null) {
                        localName = "";
                    }
                    if ((prefix = domElement.getPrefix()) == null) {
                        prefix = "";
                    }
                    QName xmlName = new QName(namespaceURI, localName, prefix);
                    String stringValue = domElement.getTextContent();
                    return PMMLObjectUtil.createExpression(new JAXBElement(xmlName, String.class, (Object)stringValue), context);
                }
            }
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    public static void addValueConstructorParam(Field valueConstructorField, Object value, JInvocation invocation, TranslationContext context) {
        if (value == null) {
            invocation.arg(JExpr._null());
            return;
        }
        if (value instanceof List) {
            List elements = (List)value;
            JInvocation listInvocation = context.staticInvoke(Arrays.class, "asList", new Object[0]);
            PMMLObjectUtil.initializeArray(valueConstructorField, elements, listInvocation, context);
            invocation.arg((JExpression)listInvocation);
        } else {
            invocation.arg(PMMLObjectUtil.createExpression(value, context));
        }
    }

    public static JInvocation addSetterMethod(Field setterMethodField, Object value, JInvocation invocation, TranslationContext context) {
        if (value == null) {
            return invocation;
        }
        if (value instanceof List) {
            List elements = (List)value;
            if (elements.isEmpty()) {
                return invocation;
            }
            invocation = JExpr.invoke((JExpression)invocation, (String)PMMLObjectUtil.formatSetterName("add", setterMethodField));
            PMMLObjectUtil.initializeArray(setterMethodField, elements, invocation, context);
        } else {
            Class<?> valueClazz = value.getClass();
            if (valueClazz.isPrimitive() && ReflectionUtil.isDefaultValue((Object)value)) {
                return invocation;
            }
            invocation = JExpr.invoke((JExpression)invocation, (String)PMMLObjectUtil.formatSetterName("set", setterMethodField));
            invocation.arg(PMMLObjectUtil.createExpression(value, context));
        }
        return invocation;
    }

    private static JInvocation initializeArray(Field field, List<?> elements, JInvocation invocation, TranslationContext context) {
        Class<?> listClazz = field.getType();
        if (!List.class.equals(listClazz)) {
            throw new IllegalArgumentException();
        }
        ParameterizedType listType = (ParameterizedType)field.getGenericType();
        Type listElementType = listType.getActualTypeArguments()[0];
        return PMMLObjectUtil.initializeArray((Class)listElementType, elements, invocation, context);
    }

    private static JInvocation initializeArray(Class<?> listElementType, List<?> elements, JInvocation invocation, TranslationContext context) {
        if (elements.size() <= 256) {
            for (Object element : elements) {
                invocation.arg(PMMLObjectUtil.createExpression(element, context));
            }
        } else {
            JMethod method = PMMLObjectUtil.createArrayBuilderMethod(listElementType, elements, context);
            invocation.arg((JExpression)JExpr.invoke((JMethod)method));
        }
        return invocation;
    }

    private static String formatSetterName(String prefix, Field field) {
        String name = field.getName();
        return prefix + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static <F extends org.dmg.pmml.Field<F>> List<Value> ensureEditableValues(F field) {
        Field valuesField = ReflectionUtil.getField(field.getClass(), (String)"values");
        ArrayList values = (ArrayList)ReflectionUtil.getFieldValue((Field)valuesField, field);
        if (!(values instanceof ArrayList)) {
            values = new ArrayList(values);
            ReflectionUtil.setFieldValue((Field)valuesField, field, values);
        }
        return values;
    }
}

