/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator.mining;

import com.google.common.collect.Iterables;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.True;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.ProbabilityAggregator;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueAggregator;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.translator.AggregatorBuilder;
import org.jpmml.translator.ArrayInfoMap;
import org.jpmml.translator.FieldInfoMap;
import org.jpmml.translator.IdentifierUtil;
import org.jpmml.translator.JBinaryFileInitializer;
import org.jpmml.translator.JCodeModelUtil;
import org.jpmml.translator.JDirectInitializer;
import org.jpmml.translator.MethodScope;
import org.jpmml.translator.ModelTranslator;
import org.jpmml.translator.PMMLObjectUtil;
import org.jpmml.translator.Scope;
import org.jpmml.translator.TranslationContext;
import org.jpmml.translator.ValueBuilder;
import org.jpmml.translator.mining.MiningModelTranslator;
import org.jpmml.translator.tree.NodeScoreDistributionManager;
import org.jpmml.translator.tree.NodeScoreManager;
import org.jpmml.translator.tree.Scorer;
import org.jpmml.translator.tree.TreeModelTranslator;

public class TreeModelAggregatorTranslator
extends MiningModelTranslator {
    public TreeModelAggregatorTranslator(PMML pmml, MiningModel miningModel) {
        super(pmml, miningModel);
        MiningFunction miningFunction = miningModel.requireMiningFunction();
        switch (miningFunction) {
            case REGRESSION: 
            case CLASSIFICATION: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)miningModel, (Enum)miningFunction);
            }
        }
        MathContext mathContext = miningModel.getMathContext();
        Segmentation segmentation = miningModel.requireSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.requireMultipleModelMethod();
        switch (multipleModelMethod) {
            case SUM: 
            case WEIGHTED_SUM: 
            case AVERAGE: 
            case WEIGHTED_AVERAGE: 
            case MEDIAN: 
            case WEIGHTED_MEDIAN: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        Segmentation.MissingPredictionTreatment missingPredictionTreatment = segmentation.getMissingPredictionTreatment();
        switch (missingPredictionTreatment) {
            case RETURN_MISSING: 
            case CONTINUE: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)missingPredictionTreatment);
            }
        }
        List segments = segmentation.requireSegments();
        for (Segment segment : segments) {
            True _true = (True)segment.requirePredicate(True.class);
            TreeModel treeModel = (TreeModel)segment.requireModel(TreeModel.class);
            if (treeModel.getMathContext() != mathContext) {
                throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)treeModel.getMathContext());
            }
            TreeModelAggregatorTranslator.checkMiningSchema((Model)treeModel);
            TreeModelAggregatorTranslator.checkTargets((Model)treeModel);
            TreeModelAggregatorTranslator.checkOutput((Model)treeModel);
            ModelTranslator<?> modelTranslator = this.newModelTranslator((Model)treeModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMethod translateRegressor(TranslationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.requireSegmentation();
        JMethod evaluateMethod = TreeModelAggregatorTranslator.createEvaluatorMethod(Value.class, (PMMLObject)segmentation, true, context);
        try {
            context.pushScope(new MethodScope(evaluateMethod));
            this.translateValueAggregatorSegmentation(segmentation, context);
        }
        finally {
            context.popScope();
        }
        return evaluateMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMethod translateClassifier(TranslationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.requireSegmentation();
        JMethod evaluateMethod = TreeModelAggregatorTranslator.createEvaluatorMethod(Classification.class, (PMMLObject)segmentation, true, context);
        try {
            context.pushScope(new MethodScope(evaluateMethod));
            this.translateProbabilityAggregatorSegmentation(segmentation, context);
        }
        finally {
            context.popScope();
        }
        return evaluateMethod;
    }

    @Override
    public FieldInfoMap getFieldInfos(Set<? extends PMMLObject> bodyObjects) {
        Segmentation segmentation = (Segmentation)Iterables.getOnlyElement(bodyObjects);
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>();
        List segments = segmentation.requireSegments();
        for (Segment segment : segments) {
            TreeModel treeModel = (TreeModel)segment.requireModel(TreeModel.class);
            Node node = treeModel.getNode();
            nodes.add(node);
        }
        FieldInfoMap fieldInfos = super.getFieldInfos(nodes);
        ArrayInfoMap arrayInfos = this.getArrayInfos();
        if (!arrayInfos.isEmpty()) {
            this.declareArrayFields(arrayInfos.values());
        }
        fieldInfos = TreeModelTranslator.enhanceFieldInfos(nodes, fieldInfos, arrayInfos);
        return fieldInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void translateValueAggregatorSegmentation(Segmentation segmentation, TranslationContext context) {
        miningModel = (MiningModel)this.getModel();
        mathContext = miningModel.getMathContext();
        multipleModelMethod = segmentation.requireMultipleModelMethod();
        segments = segmentation.requireSegments();
        fieldInfos = this.getFieldInfos(Collections.singleton(segmentation));
        valueFactoryRef = context.getValueFactoryVariable();
        aggregatorBuilder = new AggregatorBuilder(context);
        switch (2.$SwitchMap$org$dmg$pmml$mining$Segmentation$MultipleModelMethod[multipleModelMethod.ordinal()]) {
            case 1: 
            case 3: {
                aggregatorBuilder.construct((Class)ValueAggregator.UnivariateStatistic.class, "aggregator", new Object[]{valueFactoryRef});
                break;
            }
            case 5: {
                aggregatorBuilder.construct((Class)ValueAggregator.Median.class, "aggregator", new Object[]{valueFactoryRef, segments.size()});
                break;
            }
            case 2: 
            case 4: {
                aggregatorBuilder.construct((Class)ValueAggregator.WeightedUnivariateStatistic.class, "aggregator", new Object[]{valueFactoryRef});
                break;
            }
            case 6: {
                aggregatorBuilder.construct((Class)ValueAggregator.WeightedMedian.class, "aggregator", new Object[]{valueFactoryRef, segments.size()});
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        scoreManagers = new ArrayList<NodeScoreManager>();
        weights = null;
        methods = new ArrayList<JMethod>();
        for (Segment segment : segments) {
            _true = (True)segment.requirePredicate(True.class);
            treeModel = (TreeModel)segment.requireModel(TreeModel.class);
            node = treeModel.getNode();
            scoreManager = new NodeScoreManager((JType)context.ref(Number.class), IdentifierUtil.create("scores", (PMMLObject)node));
            scoreManagers.add(scoreManager);
            switch (2.$SwitchMap$org$dmg$pmml$mining$Segmentation$MultipleModelMethod[multipleModelMethod.ordinal()]) {
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    if (weights == null) {
                        weights = new ArrayList<Number>();
                    }
                    weights.add(segment.getWeight());
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
                }
            }
            method = this.createEvaluatorMethod(treeModel, node, scoreManager, fieldInfos, context);
            methods.add(method);
            TreeModelAggregatorTranslator.pullUpDerivedFields(miningModel, (Model)treeModel);
        }
        treeFunctionInterface = this.ensureTreeModelFuncInterface(context);
        resourceInitializer = new JBinaryFileInitializer(IdentifierUtil.create(Segmentation.class.getSimpleName(), (PMMLObject)segmentation) + ".data", context);
        scoreValues = scoreManagers.stream().map((Function<NodeScoreManager, Number[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$translateValueAggregatorSegmentation$0(org.jpmml.translator.tree.NodeScoreManager ), (Lorg/jpmml/translator/tree/NodeScoreManager;)[Ljava/lang/Number;)()).collect(Collectors.toList());
        scoresVar = resourceInitializer.initNumbersList(IdentifierUtil.create("scores", (PMMLObject)segmentation), mathContext, scoreValues);
        weightsVar = null;
        if (weights != null) {
            weightValues = weights.toArray(new Number[weights.size()]);
            weightsVar = resourceInitializer.initNumbers(IdentifierUtil.create("weights", (PMMLObject)segmentation), mathContext, weightValues);
        }
        codeInitializer = new JDirectInitializer(context);
        methodsVar = codeInitializer.initLambdas(IdentifierUtil.create("methods", (PMMLObject)segmentation), treeFunctionInterface.narrow((JClass)TreeModelAggregatorTranslator.ensureArgumentsType(context)), methods);
        block = context.block();
        try {
            forLoop = block._for();
            loopVar = forLoop.init(context._ref(Integer.TYPE), "i", JExpr.lit((int)0));
            forLoop.test(loopVar.lt(JExpr.lit((int)segments.size())));
            forLoop.update(loopVar.incr());
            forBlock = forLoop.body();
            context.pushScope(new Scope(forBlock));
            indexExpr = context.declare(Integer.TYPE, "index", (JExpression)methodsVar.invoke("get").arg((JExpression)loopVar).invoke("apply").arg((JExpression)context.getArgumentsVariable().getExpression()));
            context._returnIf(indexExpr.eq(NodeScoreManager.RESULT_MISSING), JExpr._null());
            scoreExpr = scoresVar.invoke("get").arg((JExpression)loopVar).component((JExpression)indexExpr);
            switch (2.$SwitchMap$org$dmg$pmml$mining$Segmentation$MultipleModelMethod[multipleModelMethod.ordinal()]) {
                case 1: 
                case 3: 
                case 5: {
                    aggregatorBuilder.update("add", new Object[]{scoreExpr});
                    ** break;
lbl79:
                    // 1 sources

                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    weightExpr = weightsVar.invoke("get").arg((JExpression)loopVar);
                    aggregatorBuilder.update("add", new Object[]{scoreExpr, weightExpr});
                    ** break;
lbl85:
                    // 1 sources

                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
                }
            }
        }
        finally {
            context.popScope();
        }
        aggregatorVar = aggregatorBuilder.getVariable();
        switch (2.$SwitchMap$org$dmg$pmml$mining$Segmentation$MultipleModelMethod[multipleModelMethod.ordinal()]) {
            case 1: {
                valueInit = aggregatorVar.invoke("sum");
                break;
            }
            case 2: {
                valueInit = aggregatorVar.invoke("weightedSum");
                break;
            }
            case 3: {
                valueInit = aggregatorVar.invoke("average");
                break;
            }
            case 4: {
                valueInit = aggregatorVar.invoke("weightedAverage");
                break;
            }
            case 5: {
                valueInit = aggregatorVar.invoke("median");
                break;
            }
            case 6: {
                valueInit = aggregatorVar.invoke("weightedMedian");
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        resultBuilder = new ValueBuilder(context).declare(context.getValueType(), "result", (JExpression)valueInit);
        context._return((JExpression)resultBuilder.getVariable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void translateProbabilityAggregatorSegmentation(Segmentation segmentation, TranslationContext context) {
        miningModel = (MiningModel)this.getModel();
        mathContext = miningModel.getMathContext();
        multipleModelMethod = segmentation.requireMultipleModelMethod();
        segments = segmentation.requireSegments();
        fieldInfos = this.getFieldInfos(Collections.singleton(segmentation));
        valueFactoryRef = context.getValueFactoryVariable();
        aggregatorBuilder = new AggregatorBuilder(context);
        switch (2.$SwitchMap$org$dmg$pmml$mining$Segmentation$MultipleModelMethod[multipleModelMethod.ordinal()]) {
            case 3: {
                aggregatorBuilder.construct((Class)ProbabilityAggregator.Average.class, "aggregator", new Object[]{valueFactoryRef});
                break;
            }
            case 4: {
                aggregatorBuilder.construct((Class)ProbabilityAggregator.WeightedAverage.class, "aggregator", new Object[]{valueFactoryRef});
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        categories = this.getTargetCategories();
        scoreDistributionManagers = new ArrayList<1>();
        weights = null;
        methods = new ArrayList<JMethod>();
        for (Segment segment : segments) {
            _true = (True)segment.requirePredicate(True.class);
            treeModel = (TreeModel)segment.requireModel(TreeModel.class);
            node = treeModel.getNode();
            scoreDistributionManager = new NodeScoreDistributionManager<Number>((JType)context.ref(Number[].class), IdentifierUtil.create("scores", (PMMLObject)node), categories){
                private ValueFactory<Number> valueFactory;
                {
                    super(componentType, name, categories);
                    this.valueFactory = ModelTranslator.getValueFactory((Model)treeModel);
                }

                @Override
                public ValueFactory<Number> getValueFactory() {
                    return this.valueFactory;
                }
            };
            scoreDistributionManagers.add(scoreDistributionManager);
            switch (2.$SwitchMap$org$dmg$pmml$mining$Segmentation$MultipleModelMethod[multipleModelMethod.ordinal()]) {
                case 3: {
                    break;
                }
                case 4: {
                    if (weights == null) {
                        weights = new ArrayList<Number>();
                    }
                    weights.add(segment.getWeight());
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
                }
            }
            method = this.createEvaluatorMethod(treeModel, node, scoreDistributionManager, fieldInfos, context);
            methods.add(method);
            TreeModelAggregatorTranslator.pullUpDerivedFields(miningModel, (Model)treeModel);
        }
        treeModelFuncInterface = this.ensureTreeModelFuncInterface(context);
        resourceInitializer = new JBinaryFileInitializer(IdentifierUtil.create(Segmentation.class.getSimpleName(), (PMMLObject)segmentation) + ".data", context);
        scoreValues = scoreDistributionManagers.stream().map((Function<NodeScoreDistributionManager, Number[][]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$translateProbabilityAggregatorSegmentation$1(org.jpmml.translator.tree.NodeScoreDistributionManager ), (Lorg/jpmml/translator/tree/NodeScoreDistributionManager;)[[Ljava/lang/Number;)()).collect(Collectors.toList());
        scoresVar = resourceInitializer.initNumberArraysList(IdentifierUtil.create("scores", (PMMLObject)segmentation), mathContext, scoreValues, categories.length);
        weightsVar = null;
        if (weights != null) {
            weightValues = weights.toArray(new Number[weights.size()]);
            weightsVar = resourceInitializer.initNumbers(IdentifierUtil.create("weights", (PMMLObject)segmentation), mathContext, weightValues);
        }
        codeInitializer = new JDirectInitializer(context);
        methodsVar = codeInitializer.initLambdas(IdentifierUtil.create("methods", (PMMLObject)segmentation), treeModelFuncInterface.narrow((JClass)TreeModelAggregatorTranslator.ensureArgumentsType(context)), methods);
        categoriesVar = codeInitializer.initTargetCategories("targetCategories", Arrays.asList(categories));
        aggregatorBuilder.update("init", new Object[]{categoriesVar});
        block = context.block();
        try {
            forLoop = block._for();
            loopVar = forLoop.init(context._ref(Integer.TYPE), "i", JExpr.lit((int)0));
            forLoop.test(loopVar.lt(JExpr.lit((int)segments.size())));
            forLoop.update(loopVar.incr());
            forBlock = forLoop.body();
            context.pushScope(new Scope(forBlock));
            indexExpr = context.declare(Integer.TYPE, "index", (JExpression)methodsVar.invoke("get").arg((JExpression)loopVar).invoke("apply").arg((JExpression)context.getArgumentsVariable().getExpression()));
            context._returnIf(indexExpr.eq(NodeScoreDistributionManager.RESULT_MISSING), JExpr._null());
            scoreExpr = scoresVar.invoke("get").arg((JExpression)loopVar).component((JExpression)indexExpr);
            switch (2.$SwitchMap$org$dmg$pmml$mining$Segmentation$MultipleModelMethod[multipleModelMethod.ordinal()]) {
                case 3: {
                    aggregatorBuilder.update("add", new Object[]{scoreExpr});
                    ** break;
lbl75:
                    // 1 sources

                    break;
                }
                case 4: {
                    weightExpr = weightsVar.invoke("get").arg((JExpression)loopVar);
                    aggregatorBuilder.update("add", new Object[]{scoreExpr, weightExpr});
                    ** break;
lbl81:
                    // 1 sources

                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
                }
            }
        }
        finally {
            context.popScope();
        }
        aggregatorVar = aggregatorBuilder.getVariable();
        switch (2.$SwitchMap$org$dmg$pmml$mining$Segmentation$MultipleModelMethod[multipleModelMethod.ordinal()]) {
            case 3: {
                valueMapInit = aggregatorVar.invoke("averageMap");
                break;
            }
            case 4: {
                valueMapInit = aggregatorVar.invoke("weightedAverageMap");
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        context._return((JExpression)context._new(ProbabilityDistribution.class, new Object[]{valueMapInit}));
    }

    private JDefinedClass ensureTreeModelFuncInterface(TranslationContext context) {
        JDefinedClass owner = context.getOwner();
        JDefinedClass definedClazz = JCodeModelUtil.getNestedClass(owner, "TreeModelFunction");
        if (definedClazz != null) {
            return definedClazz;
        }
        try {
            definedClazz = owner._interface("TreeModelFunction");
        }
        catch (JClassAlreadyExistsException jcaee) {
            throw new IllegalArgumentException(jcaee);
        }
        definedClazz.annotate(FunctionalInterface.class);
        JTypeVar typeVar = definedClazz.generify("T");
        JMethod method = definedClazz.method(33, Integer.TYPE, "apply");
        method.param((JType)typeVar, "value");
        return definedClazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S> JMethod createEvaluatorMethod(TreeModel treeModel, Node node, Scorer<S> scorer, FieldInfoMap fieldInfos, TranslationContext context) {
        JDefinedClass treeModelClazz = PMMLObjectUtil.createMemberClass(28, IdentifierUtil.create(TreeModel.class.getSimpleName(), (PMMLObject)treeModel), context);
        try {
            context.pushOwner(treeModelClazz);
            JMethod method = TreeModelAggregatorTranslator.createEvaluatorMethod(Integer.TYPE, (PMMLObject)node, false, context);
            try {
                context.pushScope(new MethodScope(method));
                TreeModelTranslator.translateNode(treeModel, node, scorer, fieldInfos, context);
                JMethod jMethod = method;
                context.popScope();
                return jMethod;
            }
            catch (Throwable throwable) {
                context.popScope();
                throw throwable;
            }
        }
        finally {
            context.popOwner();
        }
    }

    private static /* synthetic */ Number[][] lambda$translateProbabilityAggregatorSegmentation$1(NodeScoreDistributionManager scoreDistributionManager) {
        return scoreDistributionManager.getValues();
    }

    private static /* synthetic */ Number[] lambda$translateValueAggregatorSegmentation$0(NodeScoreManager scoreManager) {
        return scoreManager.getValues();
    }
}

