/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.transpiler;

import com.sun.codemodel.JCodeModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.dmg.pmml.PMML;
import org.jpmml.model.PMMLUtil;
import org.jpmml.transpiler.Transpiler;
import org.jpmml.transpiler.TranspilerUtil;

public class FileTranspiler
extends Transpiler {
    private File file = null;

    public FileTranspiler(String className, File file) {
        super(className);
        this.setFile(file);
    }

    @Override
    public PMML transpile(PMML pmml) throws IOException {
        File file = this.getFile();
        JCodeModel codeModel = this.compile(this.translate(pmml));
        try (FileOutputStream os = new FileOutputStream(file);){
            TranspilerUtil.archive(codeModel, os);
        }
        return PMMLUtil.load((URL)file.toURI().toURL());
    }

    public File getFile() {
        return this.file;
    }

    private void setFile(File file) {
        this.file = Objects.requireNonNull(file);
    }
}

