/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator.mining;

import java.util.List;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.evaluator.InputFieldUtil;
import org.jpmml.model.UnsupportedElementException;
import org.jpmml.model.UnsupportedElementListException;
import org.jpmml.translator.ModelTranslator;
import org.jpmml.translator.ModelTranslatorFactory;

public abstract class MiningModelTranslator
extends ModelTranslator<MiningModel> {
    public MiningModelTranslator(PMML pmml, MiningModel miningModel) {
        super(pmml, miningModel);
        if (miningModel.hasEmbeddedModels()) {
            List embeddedModels = miningModel.getEmbeddedModels();
            throw new UnsupportedElementListException(embeddedModels);
        }
        Segmentation segmentation = miningModel.requireSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.requireMultipleModelMethod();
        List segments = segmentation.requireSegments();
    }

    public ModelTranslator<?> newModelTranslator(Model model) {
        PMML pmml = this.getPMML();
        ModelTranslatorFactory modelTranslatorFactory = ModelTranslatorFactory.getInstance();
        return modelTranslatorFactory.newModelTranslator(pmml, model);
    }

    public static void checkMiningSchema(Model model) {
        MiningSchema miningSchema = model.requireMiningSchema();
        if (miningSchema.hasMiningFields()) {
            List miningFields = miningSchema.getMiningFields();
            block3: for (MiningField miningField : miningFields) {
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case ACTIVE: {
                        break;
                    }
                    default: {
                        continue block3;
                    }
                }
                if (InputFieldUtil.isDefault(null, (MiningField)miningField)) continue;
                throw new UnsupportedElementException((PMMLObject)miningField);
            }
        }
    }

    public static void checkLocalTransformations(Model model) {
        LocalTransformations localTransformations = model.getLocalTransformations();
        if (localTransformations != null && localTransformations.hasDerivedFields()) {
            throw new UnsupportedElementException((PMMLObject)localTransformations);
        }
    }

    public static void checkTargets(Model model) {
        Targets targets = model.getTargets();
        if (targets != null && targets.hasTargets()) {
            throw new UnsupportedElementException((PMMLObject)targets);
        }
    }

    public static void checkOutput(Model model) {
        Output output = model.getOutput();
        if (output != null && output.hasOutputFields()) {
            throw new UnsupportedElementException((PMMLObject)output);
        }
    }

    public static void pullUpDerivedFields(MiningModel parent, Model child) {
        LocalTransformations parentLocalTransformations = parent.getLocalTransformations();
        LocalTransformations childLocalTransformations = child.getLocalTransformations();
        if (childLocalTransformations != null && childLocalTransformations.hasDerivedFields()) {
            if (parentLocalTransformations == null) {
                parentLocalTransformations = new LocalTransformations();
                parent.setLocalTransformations(parentLocalTransformations);
            }
            parentLocalTransformations.getDerivedFields().addAll(childLocalTransformations.getDerivedFields());
            child.setLocalTransformations(null);
        }
    }

    public static void pullUpOutputFields(MiningModel parent, Model child) {
        Output parentOutput = parent.getOutput();
        Output childOutput = child.getOutput();
        if (childOutput != null && childOutput.hasOutputFields()) {
            if (parentOutput == null) {
                parentOutput = new Output();
                parent.setOutput(parentOutput);
            }
            parentOutput.getOutputFields().addAll(childOutput.getOutputFields());
        }
    }
}

