/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator.tree;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.dmg.pmml.tree.Node;
import org.jpmml.translator.tree.NodeGroup;
import org.jpmml.translator.tree.NodeUtil;

public class NodeGroupUtil {
    private NodeGroupUtil() {
    }

    public static List<NodeGroup> group(List<Node> nodes) {
        LinkedHashMap<String, NodeGroup> nodeGroups = new LinkedHashMap<String, NodeGroup>();
        for (Node node : nodes) {
            String parentId = NodeGroupUtil.getParentId(node);
            NodeGroup nodeGroup = (NodeGroup)nodeGroups.get(parentId);
            if (nodeGroup == null) {
                nodeGroup = new NodeGroup(parentId);
                nodeGroups.put(parentId, nodeGroup);
            }
            nodeGroup.add(node);
        }
        return new ArrayList<NodeGroup>(nodeGroups.values());
    }

    public static String getParentId(Node node) {
        return NodeUtil.getExtension(node, "parent");
    }

    public static void setParentId(Node node, int parentId) {
        NodeUtil.addExtension(node, "parent", String.valueOf(parentId));
    }
}

